<?php
$course_details = $this->crud_model->get_course_by_id($course_id)->row_array();
$lessons = $this->crud_model->get_lessons('course', $course_details['id']);
$instructor_details = $this->user_model->get_all_user($course_details['creator'])->row_array();
$course_duration = $this->crud_model->get_total_duration_of_lesson_by_course_id($course_details['id']);
$number_of_enrolments = $this->crud_model->enrol_history($course_details['id'])->num_rows();
$total_rating =  $this->crud_model->get_ratings('course', $course_details['id'], true)->row()->rating;
$number_of_ratings = $this->crud_model->get_ratings('course', $course_details['id'])->num_rows();
if ($number_of_ratings > 0) {
    $average_ceil_rating = ceil($total_rating / $number_of_ratings);
} else {
    $average_ceil_rating = 0;
}
?>

<!---------- Banner Start ---------->
<section>
    <div class="bread-crumb courses-details">
        <div class="container">
            <div class="row">
                <div class="col-lg-8 col-md-12 col-sm-12 col-12">
                    <div class="courses-details-1st-text">
                        <nav aria-label="breadcrumb ">
                            <ol class="breadcrumb nBread pt-4">
                                <li class="breadcrumb-item p-0"><a href="<?php echo site_url(); ?>"><?php echo site_phrase('Home')?></a></li>
                                <li class="breadcrumb-item p-0"><a href="javascript:;"><?php echo site_phrase('Courses')?></a></li>
                                <li class="breadcrumb-item p-0 active" aria-current="page"><?php echo site_phrase('Details')?></li>
                            </ol>
                        </nav>

                        <h1><?php echo $course_details['title']; ?></h1>
                        <p><?php echo $course_details['short_description']; ?></p>
                        <div class="review">
                            <div class="row ">
                                <div class="col-12 course-heading-info">
                                    <div class="info-tag eInfo">
                                        <img loading="lazy" width="30px" height="30px" class="rounded-circle object-fit-cover me-2" src="<?php echo $this->user_model->get_user_image_url($instructor_details['id']); ?>">
                                        <p class="me-1 f-14"><?php echo get_phrase('Created By'); ?></p>
                                        <p>
                                            <a class="created-by-instructor" href="<?php echo site_url('home/instructor_page/' . $course_details['creator']); ?>"><?php echo $instructor_details['first_name'] . ' ' . $instructor_details['last_name']; ?></a>
                                        </p>
                                    </div>

                                    <div class="info-tag">
                                        <div class="icon">
                                            <ul>
                                                <?php for ($i = 1; $i < 6; $i++) : ?>
                                                    <?php if ($i <= $average_ceil_rating) : ?>
                                                        <li class="me-0"><i class="fa-solid fa-star text-15px  mt-7px"></i></li>
                                                    <?php else : ?>
                                                        <li class="me-0"><i class="fa-solid fa-star text-shadow text-15px  mt-7px"></i></li>
                                                    <?php endif; ?>
                                                <?php endfor; ?>
                                                <p class="text-15px mt-1">(<?php echo $number_of_ratings . ' ' . get_phrase('Reviews'); ?>)</p>
                                            </ul>
                                        </div>
                                    </div>

                                    <div class="info-tag">
                                        <?php if ($course_duration) : ?>
                                            <i class="fa-regular fa-clock text-15px mt-7px me-2"></i>
                                            <p class="text-15px mt-1"><?php echo $course_duration; ?></p>
                                        <?php endif; ?>
                                    </div>
                                    <div class="info-tag">
                                        <svg class="mt-7px me-2" width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M6.86992 8.715C6.84742 8.715 6.83242 8.715 6.80992 8.715C6.77242 8.7075 6.71992 8.7075 6.67492 8.715C4.49992 8.6475 2.85742 6.9375 2.85742 4.83C2.85742 2.685 4.60492 0.9375 6.74992 0.9375C8.89492 0.9375 10.6424 2.685 10.6424 4.83C10.6349 6.9375 8.98492 8.6475 6.89242 8.715C6.88492 8.715 6.87742 8.715 6.86992 8.715ZM6.74992 2.0625C5.22742 2.0625 3.98242 3.3075 3.98242 4.83C3.98242 6.33 5.15242 7.5375 6.64492 7.59C6.68992 7.5825 6.78742 7.5825 6.88492 7.59C8.35492 7.5225 9.50992 6.315 9.51742 4.83C9.51742 3.3075 8.27242 2.0625 6.74992 2.0625Z" fill="#0D0C23"/>
                                            <path d="M12.4048 8.8125C12.3823 8.8125 12.3598 8.8125 12.3373 8.805C12.0298 8.835 11.7148 8.6175 11.6848 8.31C11.6548 8.0025 11.8423 7.725 12.1498 7.6875C12.2398 7.68 12.3373 7.68 12.4198 7.68C13.5148 7.62 14.3698 6.72 14.3698 5.6175C14.3698 4.4775 13.4473 3.555 12.3073 3.555C11.9998 3.5625 11.7448 3.3075 11.7448 3C11.7448 2.6925 11.9998 2.4375 12.3073 2.4375C14.0623 2.4375 15.4948 3.87 15.4948 5.625C15.4948 7.35 14.1448 8.745 12.4273 8.8125C12.4198 8.8125 12.4123 8.8125 12.4048 8.8125Z" fill="#0D0C23"/>
                                            <path d="M6.87672 16.9125C5.40672 16.9125 3.92922 16.5375 2.81172 15.7875C1.76922 15.0975 1.19922 14.1525 1.19922 13.125C1.19922 12.0975 1.76922 11.145 2.81172 10.4475C5.06172 8.955 8.70672 8.955 10.9417 10.4475C11.9767 11.1375 12.5542 12.0825 12.5542 13.11C12.5542 14.1375 11.9842 15.09 10.9417 15.7875C9.81672 16.5375 8.34672 16.9125 6.87672 16.9125ZM3.43422 11.3925C2.71422 11.8725 2.32422 12.4875 2.32422 13.1325C2.32422 13.77 2.72172 14.385 3.43422 14.8575C5.30172 16.11 8.45172 16.11 10.3192 14.8575C11.0392 14.3775 11.4292 13.7625 11.4292 13.1175C11.4292 12.48 11.0317 11.865 10.3192 11.3925C8.45172 10.1475 5.30172 10.1475 3.43422 11.3925Z" fill="#0D0C23"/>
                                            <path d="M13.7546 15.5625C13.4921 15.5625 13.2596 15.3825 13.2071 15.1125C13.1471 14.805 13.3421 14.5125 13.6421 14.445C14.1146 14.3475 14.5496 14.16 14.8871 13.8975C15.3146 13.575 15.5471 13.17 15.5471 12.7425C15.5471 12.315 15.3146 11.91 14.8946 11.595C14.5646 11.34 14.1521 11.16 13.6646 11.0475C13.3646 10.98 13.1696 10.68 13.2371 10.3725C13.3046 10.0725 13.6046 9.87751 13.9121 9.94501C14.5571 10.0875 15.1196 10.3425 15.5771 10.695C16.2746 11.22 16.6721 11.9625 16.6721 12.7425C16.6721 13.5225 16.2671 14.265 15.5696 14.7975C15.1046 15.1575 14.5196 15.42 13.8746 15.5475C13.8296 15.5625 13.7921 15.5625 13.7546 15.5625Z" fill="#0D0C23"/>
                                            </svg>

                                        <p class="text-15px mt-1"><?php echo $number_of_enrolments ?> <?php echo get_phrase('Enrolled'); ?></p>
                                    </div>

                                </div>
                                <div class="col-12 course-heading-info">
                                    <div class="info-tag">
                                    <svg class="mt-2 me-2" width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M12.7418 7.28247H5.25684C4.94934 7.28247 4.69434 7.02747 4.69434 6.71997C4.69434 6.41247 4.94934 6.15747 5.25684 6.15747H12.7418C13.0493 6.15747 13.3043 6.41247 13.3043 6.71997C13.3043 7.02747 13.0493 7.28247 12.7418 7.28247Z" fill="#0D0C23"/>
                                        <path d="M9 7.28252C8.6925 7.28252 8.4375 7.02752 8.4375 6.72002V5.46002C8.4375 5.15252 8.6925 4.89752 9 4.89752C9.3075 4.89752 9.5625 5.15252 9.5625 5.46002V6.72002C9.5625 7.02752 9.3075 7.28252 9 7.28252Z" fill="#0D0C23"/>
                                        <path d="M5.25 13.1024C4.9425 13.1024 4.6875 12.8474 4.6875 12.5399C4.6875 12.2324 4.9425 11.9774 5.25 11.9774C8.04 11.9774 10.3125 9.61496 10.3125 6.70496C10.3125 6.39746 10.5675 6.14246 10.875 6.14246C11.1825 6.14246 11.4375 6.39746 11.4375 6.70496C11.4375 10.2375 8.6625 13.1024 5.25 13.1024Z" fill="#0D0C23"/>
                                        <path d="M12.7499 13.1025C11.2724 13.1025 9.89992 12.3675 8.89492 11.025C8.70742 10.7775 8.75994 10.425 9.00744 10.2375C9.25494 10.05 9.60743 10.1025 9.79493 10.35C10.5899 11.4 11.6399 11.9775 12.7574 11.9775C13.0649 11.9775 13.3199 12.2325 13.3199 12.54C13.3199 12.8475 13.0574 13.1025 12.7499 13.1025Z" fill="#0D0C23"/>
                                        <path d="M11.25 17.0625H6.75C2.6775 17.0625 0.9375 15.3225 0.9375 11.25V6.75C0.9375 2.6775 2.6775 0.9375 6.75 0.9375H11.25C15.3225 0.9375 17.0625 2.6775 17.0625 6.75V11.25C17.0625 15.3225 15.3225 17.0625 11.25 17.0625ZM6.75 2.0625C3.2925 2.0625 2.0625 3.2925 2.0625 6.75V11.25C2.0625 14.7075 3.2925 15.9375 6.75 15.9375H11.25C14.7075 15.9375 15.9375 14.7075 15.9375 11.25V6.75C15.9375 3.2925 14.7075 2.0625 11.25 2.0625H6.75Z" fill="#0D0C23"/>
                                        </svg>

                                        <p class="f-14 mt-1"><?php echo ucfirst($course_details['language']); ?></p>
                                    </div>

                                    <div class="info-tag">
                                        <p>
                                        <svg class="mt-2 me-2" width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M11.615 11.8775C11.5175 11.8775 11.42 11.855 11.33 11.795L9.005 10.4075C8.4275 10.0625 8 9.305 8 8.6375V5.5625C8 5.255 8.255 5 8.5625 5C8.87 5 9.125 5.255 9.125 5.5625V8.6375C9.125 8.9075 9.35 9.305 9.5825 9.44L11.9075 10.8275C12.1775 10.985 12.26 11.33 12.1025 11.6C11.99 11.78 11.8025 11.8775 11.615 11.8775Z" fill="#0D0C23"/>
                                            <path d="M9 17C4.58737 17 1 13.4126 1 9C1 4.58737 4.58737 1 9 1C13.4126 1 17 4.58737 17 9C17 9.34526 16.7137 9.63158 16.3684 9.63158C16.0232 9.63158 15.7368 9.34526 15.7368 9C15.7368 5.28632 12.7137 2.26316 9 2.26316C5.28632 2.26316 2.26316 5.28632 2.26316 9C2.26316 12.7137 5.28632 15.7368 9 15.7368C9.34526 15.7368 9.63158 16.0232 9.63158 16.3684C9.63158 16.7137 9.34526 17 9 17Z" fill="#0D0C23"/>
                                            </svg>

                                       </p>
                                        <p class="f-14 mt-1 me-1"><?php echo get_phrase('Last Updated'); ?></p>
                                        <p class="f-14 mt-1">
                                            <?php if ($course_details['last_modified'] > 0) : ?>
                                                <?php echo date('D, d-M-Y', $course_details['last_modified']); ?>
                                            <?php else : ?>
                                                <?php echo date('D, d-M-Y', $course_details['date_added']); ?>
                                            <?php endif; ?>
                                        </p>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</section>
<!---------- Banner Area End ---------->

<!--------- course Decription Page Start ------>
<section class="course-decription">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 col-md-12 col-sm-12 order-2 order-lg-1">
                <div class="course-left-side">
                    <ul class="nav nav-tabs" id="myTab" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="course-overview-tab" data-bs-toggle="tab" data-bs-target="#course-overview" type="button" role="tab" aria-controls="course-overview" aria-selected="true">
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M9.99964 8.56668C9.14964 8.56668 8.29964 8.41668 7.4913 8.12501C7.1663 8.00835 6.99964 7.65001 7.1163 7.32501C7.2413 7.00001 7.59964 6.83335 7.92464 6.95001C9.2663 7.43335 10.7413 7.43335 12.083 6.95001C12.408 6.83335 12.7663 7.00001 12.883 7.32501C12.9996 7.65001 12.833 8.00835 12.508 8.12501C11.6996 8.41668 10.8496 8.56668 9.99964 8.56668Z" fill="#68768B"/>
                                <path d="M15.8916 18.9583C15.4666 18.9583 14.9999 18.8333 14.5499 18.575L10.4833 16.3167C10.2416 16.1833 9.7666 16.1833 9.52494 16.3167L5.45827 18.575C4.63327 19.0333 3.7916 19.0833 3.14994 18.7C2.50827 18.325 2.1416 17.5667 2.1416 16.625V4.88332C2.1416 2.76666 3.8666 1.04166 5.98327 1.04166H14.0249C16.1416 1.04166 17.8666 2.76666 17.8666 4.88332V16.625C17.8666 17.5667 17.4999 18.325 16.8583 18.7C16.5666 18.875 16.2333 18.9583 15.8916 18.9583ZM9.99994 14.9667C10.3916 14.9667 10.7749 15.05 11.0833 15.225L15.1499 17.4833C15.5749 17.725 15.9666 17.775 16.2166 17.625C16.4666 17.475 16.6083 17.1167 16.6083 16.625V4.88332C16.6083 3.45832 15.4416 2.29166 14.0166 2.29166H5.98327C4.55827 2.29166 3.3916 3.45832 3.3916 4.88332V16.625C3.3916 17.1167 3.53327 17.4833 3.78327 17.625C4.03327 17.7667 4.4166 17.725 4.84994 17.4833L8.9166 15.225C9.22494 15.05 9.60827 14.9667 9.99994 14.9667Z" fill="#68768B"/>
                                <path d="M15.8916 18.9583C15.4666 18.9583 14.9999 18.8333 14.5499 18.575L10.4833 16.3167C10.2416 16.1833 9.7666 16.1833 9.52494 16.3167L5.45827 18.575C4.63327 19.0333 3.7916 19.0833 3.14994 18.7C2.50827 18.325 2.1416 17.5667 2.1416 16.625V4.88332C2.1416 2.76666 3.8666 1.04166 5.98327 1.04166H14.0249C16.1416 1.04166 17.8666 2.76666 17.8666 4.88332V16.625C17.8666 17.5667 17.4999 18.325 16.8583 18.7C16.5666 18.875 16.2333 18.9583 15.8916 18.9583ZM9.99994 14.9667C10.3916 14.9667 10.7749 15.05 11.0833 15.225L15.1499 17.4833C15.5749 17.725 15.9666 17.775 16.2166 17.625C16.4666 17.475 16.6083 17.1167 16.6083 16.625V4.88332C16.6083 3.45832 15.4416 2.29166 14.0166 2.29166H5.98327C4.55827 2.29166 3.3916 3.45832 3.3916 4.88332V16.625C3.3916 17.1167 3.53327 17.4833 3.78327 17.625C4.03327 17.7667 4.4166 17.725 4.84994 17.4833L8.9166 15.225C9.22494 15.05 9.60827 14.9667 9.99994 14.9667Z" fill="#68768B"/>
                                </svg>


                                <span class="ms-1"><?php echo get_phrase('Overview'); ?></button></span>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="curriculum-tab" data-bs-toggle="tab" data-bs-target="#curriculum" type="button" role="tab" aria-controls="curriculum" aria-selected="false">
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M12.5003 18.9583H7.50032C2.97533 18.9583 1.04199 17.025 1.04199 12.5V7.49999C1.04199 2.97499 2.97533 1.04166 7.50032 1.04166H9.16699C9.50866 1.04166 9.79199 1.32499 9.79199 1.66666C9.79199 2.00832 9.50866 2.29166 9.16699 2.29166H7.50032C3.65866 2.29166 2.29199 3.65832 2.29199 7.49999V12.5C2.29199 16.3417 3.65866 17.7083 7.50032 17.7083H12.5003C16.342 17.7083 17.7087 16.3417 17.7087 12.5V10.8333C17.7087 10.4917 17.992 10.2083 18.3337 10.2083C18.6753 10.2083 18.9587 10.4917 18.9587 10.8333V12.5C18.9587 17.025 17.0253 18.9583 12.5003 18.9583Z" fill="#68768B"/>
                                <path d="M7.08311 14.7417C6.57478 14.7417 6.10811 14.5583 5.76645 14.225C5.35811 13.8167 5.18311 13.225 5.27478 12.6L5.63311 10.0917C5.69978 9.60832 6.01645 8.98332 6.35811 8.64165L12.9248 2.07499C14.5831 0.416655 16.2664 0.416655 17.9248 2.07499C18.8331 2.98332 19.2414 3.90832 19.1581 4.83332C19.0831 5.58332 18.6831 6.31665 17.9248 7.06665L11.3581 13.6333C11.0164 13.975 10.3914 14.2917 9.90811 14.3583L7.39978 14.7167C7.29145 14.7417 7.18311 14.7417 7.08311 14.7417ZM13.8081 2.95832L7.24145 9.52499C7.08311 9.68332 6.89978 10.05 6.86645 10.2667L6.50811 12.775C6.47478 13.0167 6.52478 13.2167 6.64978 13.3417C6.77478 13.4667 6.97478 13.5167 7.21645 13.4833L9.72478 13.125C9.94145 13.0917 10.3164 12.9083 10.4664 12.75L17.0331 6.18332C17.5748 5.64165 17.8581 5.15832 17.8998 4.70832C17.9498 4.16665 17.6664 3.59165 17.0331 2.94999C15.6998 1.61665 14.7831 1.99165 13.8081 2.95832Z" fill="#68768B"/>
                                <path d="M16.5413 8.19167C16.483 8.19167 16.4246 8.18334 16.3746 8.16667C14.183 7.55 12.4413 5.80834 11.8246 3.61667C11.733 3.28334 11.9246 2.94167 12.258 2.84167C12.5913 2.75 12.933 2.94167 13.0246 3.275C13.5246 5.05 14.933 6.45834 16.708 6.95834C17.0413 7.05 17.233 7.4 17.1413 7.73334C17.0663 8.01667 16.8163 8.19167 16.5413 8.19167Z" fill="#68768B"/>
                                </svg>
                            <span class="ms-1"><?php echo get_phrase('Curriculum') ?></span></button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="instructor-tab" data-bs-toggle="tab" data-bs-target="#instructor" type="button" role="tab" aria-controls="contact" aria-selected="false">
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M12.5005 18.9583H7.50053C6.40053 18.9583 5.48386 18.85 4.70886 18.6167C4.42553 18.5333 4.24219 18.2583 4.25886 17.9667C4.46719 15.475 6.99219 13.5166 10.0005 13.5166C13.0089 13.5166 15.5255 15.4667 15.7422 17.9667C15.7672 18.2667 15.5839 18.5333 15.2922 18.6167C14.5172 18.85 13.6005 18.9583 12.5005 18.9583ZM5.60053 17.55C6.15053 17.6583 6.77553 17.7083 7.50053 17.7083H12.5005C13.2255 17.7083 13.8505 17.6583 14.4005 17.55C13.9589 15.95 12.1339 14.7666 10.0005 14.7666C7.86719 14.7666 6.0422 15.95 5.60053 17.55Z" fill="#68768B"/>
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M2.57922 2.57888C3.69127 1.46682 5.35535 1.04166 7.50032 1.04166H12.5003C14.6453 1.04166 16.3094 1.46682 17.4214 2.57888C18.5335 3.69094 18.9587 5.35501 18.9587 7.49999V12.5C18.9587 14.1255 18.7158 15.4701 18.1171 16.5106C17.5035 17.5769 16.5541 18.2594 15.2872 18.618C15.1077 18.6688 14.9148 18.6368 14.7614 18.5306C14.6079 18.4245 14.5099 18.2553 14.4942 18.0694C14.3467 16.3257 12.4943 14.7666 10.0003 14.7666C7.50632 14.7666 5.65397 16.3257 5.50643 18.0694C5.4907 18.2553 5.39271 18.4245 5.23927 18.5306C5.08582 18.6368 4.89296 18.6688 4.71342 18.618C3.4466 18.2594 2.4971 17.5769 1.8836 16.5106C1.28489 15.4701 1.04199 14.1255 1.04199 12.5V7.49999C1.04199 5.35501 1.46716 3.69094 2.57922 2.57888ZM3.4631 3.46277C2.70016 4.22571 2.29199 5.4783 2.29199 7.49999V12.5C2.29199 14.0245 2.52409 15.1174 2.96705 15.8873C3.29468 16.4567 3.75736 16.8836 4.40454 17.1795C5.0249 15.0073 7.38221 13.5166 10.0003 13.5166C12.6184 13.5166 14.9758 15.0073 15.5961 17.1795C16.2433 16.8836 16.706 16.4567 17.0336 15.8873C17.4766 15.1174 17.7087 14.0245 17.7087 12.5V7.49999C17.7087 5.4783 17.3005 4.22571 16.5375 3.46277C15.7746 2.69982 14.522 2.29166 12.5003 2.29166H7.50032C5.47863 2.29166 4.22604 2.69982 3.4631 3.46277ZM10.0003 6.45832C8.69551 6.45832 7.64199 7.51185 7.64199 8.81667C7.64199 10.1238 8.69776 11.1833 10.0003 11.1833C11.3029 11.1833 12.3587 10.1238 12.3587 8.81667C12.3587 7.51185 11.3051 6.45832 10.0003 6.45832ZM6.39199 8.81667C6.39199 6.8215 8.00514 5.20832 10.0003 5.20832C11.9955 5.20832 13.6087 6.8215 13.6087 8.81667C13.6087 10.8096 11.9978 12.4333 10.0003 12.4333C8.00289 12.4333 6.39199 10.8096 6.39199 8.81667Z" fill="#68768B"/>
                                <path d="M9.99994 12.4333C8.00827 12.4333 6.3916 10.8083 6.3916 8.81666C6.3916 6.82499 8.00827 5.20831 9.99994 5.20831C11.9916 5.20831 13.6083 6.82499 13.6083 8.81666C13.6083 10.8083 11.9916 12.4333 9.99994 12.4333ZM9.99994 6.45831C8.69994 6.45831 7.6416 7.51666 7.6416 8.81666C7.6416 10.125 8.69994 11.1833 9.99994 11.1833C11.2999 11.1833 12.3583 10.125 12.3583 8.81666C12.3583 7.51666 11.2999 6.45831 9.99994 6.45831Z" fill="#68768B"/>
                                </svg>



                                <span class="ms-1"><?php echo get_phrase('Instructor') ?></span></button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="reviews-tab" data-bs-toggle="tab" data-bs-target="#reviews" type="button" role="tab" aria-controls="reviews" aria-selected="false">
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M14.0837 15.8417C13.8253 15.8417 13.567 15.7667 13.342 15.6167L12.542 15.0917C12.317 14.9417 12.2087 14.6584 12.2837 14.4C12.342 14.2084 12.367 13.9833 12.367 13.7333V10.3417C12.367 8.98332 11.517 8.13335 10.1587 8.13335H4.50032C4.40032 8.13335 4.30866 8.1417 4.21699 8.15003C4.04199 8.15837 3.87533 8.10002 3.742 7.98336C3.60866 7.86669 3.54199 7.70003 3.54199 7.52503V5.21668C3.54199 2.76668 5.25866 1.05002 7.70866 1.05002H14.792C17.242 1.05002 18.9587 2.76668 18.9587 5.21668V9.46666C18.9587 10.675 18.5503 11.7417 17.8003 12.475C17.2003 13.0833 16.367 13.475 15.417 13.5917V14.5167C15.417 15.0167 15.142 15.4667 14.7087 15.7C14.5087 15.7917 14.292 15.8417 14.0837 15.8417ZM13.5837 14.275L14.1253 14.5833C14.1753 14.5583 14.1753 14.5167 14.1753 14.5083V13C14.1753 12.6583 14.4587 12.375 14.8003 12.375C15.6753 12.375 16.417 12.1 16.9253 11.5834C17.4503 11.0667 17.717 10.3333 17.717 9.45832V5.20834C17.717 3.43334 16.5753 2.29168 14.8003 2.29168H7.71699C5.94199 2.29168 4.80032 3.43334 4.80032 5.20834V6.87501H10.167C12.2003 6.87501 13.6253 8.30003 13.6253 10.3334V13.725C13.617 13.9167 13.6087 14.1 13.5837 14.275Z" fill="#68768B"/>
                                <path d="M5.05866 18.9583C4.87533 18.9583 4.68366 18.9167 4.50866 18.825C4.117 18.6167 3.87532 18.2167 3.87532 17.7667V17.1333C3.14199 17.0167 2.492 16.7083 2.00866 16.225C1.37533 15.5916 1.04199 14.725 1.04199 13.725V10.3334C1.04199 8.45002 2.27532 7.06668 4.10865 6.89168C4.24199 6.88335 4.36699 6.875 4.50032 6.875H10.1587C12.192 6.875 13.617 8.30002 13.617 10.3334V13.725C13.617 14.0916 13.5753 14.4333 13.4837 14.7417C13.1087 16.2417 11.8337 17.1833 10.1587 17.1833H8.08366L5.72532 18.75C5.52532 18.8917 5.292 18.9583 5.05866 18.9583ZM4.50032 8.125C4.40032 8.125 4.30866 8.13335 4.21699 8.14168C3.01699 8.25002 2.29199 9.07502 2.29199 10.3334V13.725C2.29199 14.3916 2.50033 14.95 2.89199 15.3416C3.27533 15.725 3.83365 15.9333 4.50032 15.9333C4.84199 15.9333 5.12532 16.2167 5.12532 16.5583V17.65L7.54199 16.0417C7.64199 15.975 7.76699 15.9333 7.89199 15.9333H10.1587C11.2587 15.9333 12.0337 15.3833 12.2753 14.4167C12.3337 14.2083 12.367 13.975 12.367 13.725V10.3334C12.367 8.97502 11.517 8.125 10.1587 8.125H4.50032Z" fill="#68768B"/>
                                </svg>
                                <span class="ms-1"><?php echo get_phrase('Reviews') ?></span></button>
                        </li>
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane fade show active" id="course-overview" role="tabpanel" aria-labelledby="course-overview-tab">
                            <?php include "course_page_info_description.php"; ?>
                        </div>

                        <div class="tab-pane fade" id="curriculum" role="tabpanel" aria-labelledby="curriculum-tab">
                            <?php include "course_page_curriculum.php"; ?>
                        </div>

                        <div class="tab-pane fade" id="instructor" role="tabpanel" aria-labelledby="instructor-tab">
                            <?php include "course_page_instructor.php"; ?>
                        </div>

                        <div class="tab-pane fade" id="reviews" role="tabpanel" aria-labelledby="reviews-tab">
                            <div class="reviews">
                                <?php include "course_page_reviews.php"; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-12 col-sm-12 order-1 order-lg-2">
                <div class="course-right-section ">
                    <div class="course-card course-details-sidebar">
                        <div class="card-img">
                            <div class="courses-card-image">
                                <div class="card-video-icon" onclick="lesson_preview('<?php echo site_url('home/course_preview/' . $course_details['id']); ?>', '<?php echo get_phrase($course_details['title']) ?>')">
                                    <i class="fa-solid fa-play"></i>
                                </div>

                                <img loading="lazy" class="w-100" src="<?php echo $this->crud_model->get_course_thumbnail_url($course_details['id']); ?>">

                                <div class="courses-icon <?php if (in_array($course_details['id'], $my_wishlist_items)) echo 'red-heart'; ?>" id="coursesWishlistIcon<?php echo $course_details['id']; ?>">
                                    <i class="fa-solid fa-heart me-2 cursor-pointer checkPropagation" onclick="actionTo('<?php echo site_url('home/toggleWishlistItems/' . $course_details['id']); ?>')"></i>
                                </div>
                            </div>
                        </div>
                        <div class="ammount d-flex">
                            <?php if ($course_details['is_free_course']) : ?>
                                <h1 class="fw-500"><?php echo get_phrase('Free'); ?></h1>
                            <?php elseif ($course_details['discount_flag']) : ?>
                                <h1 class="fw-500"><?php echo currency($course_details['discounted_price']); ?></h1>
                                <h3 class="fw-500"><del><?php echo currency($course_details['price']); ?></del></h3>
                            <?php else : ?>
                                <h1 class="fw-500"><?php echo currency($course_details['price']); ?></h1>
                            <?php endif; ?>

                            <a href="<?php echo base_url('home/compare?course-1=' . slugify($course_details['title']) . '&course-id-1=' . $course_details['id']); ?>" title="<?php echo get_phrase('Compare this course') ?>" data-bs-toggle="tooltip" class="ms-auto py-2 echecks  ">
                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M13.6134 8.14665C13.3401 8.14665 13.1134 7.91998 13.1134 7.64665V5.43335C13.1134 4.60668 12.4401 3.93335 11.6134 3.93335H2.38672C2.11339 3.93335 1.88672 3.70668 1.88672 3.43335C1.88672 3.16002 2.11339 2.93335 2.38672 2.93335H11.6134C12.9934 2.93335 14.1134 4.05335 14.1134 5.43335V7.64665C14.1134 7.92665 13.8867 8.14665 13.6134 8.14665Z" fill="#0D0C23"></path>
                                            <path d="M4.49339 6.04665C4.36672 6.04665 4.24006 5.99996 4.14006 5.89996L2.03339 3.79332C1.94005 3.69998 1.88672 3.5733 1.88672 3.43996C1.88672 3.30663 1.94005 3.17998 2.03339 3.08665L4.14006 0.979961C4.33339 0.786628 4.65339 0.786628 4.84672 0.979961C5.04005 1.17329 5.04005 1.49333 4.84672 1.68667L3.0934 3.43996L4.84672 5.1933C5.04005 5.38663 5.04005 5.70663 4.84672 5.89996C4.74672 5.9933 4.62005 6.04665 4.49339 6.04665Z" fill="#0D0C23"></path>
                                            <path d="M13.6134 13.06H4.38672C3.00672 13.06 1.88672 11.94 1.88672 10.56V8.34668C1.88672 8.07335 2.11339 7.84668 2.38672 7.84668C2.66005 7.84668 2.88672 8.07335 2.88672 8.34668V10.56C2.88672 11.3867 3.56005 12.06 4.38672 12.06H13.6134C13.8867 12.06 14.1134 12.2867 14.1134 12.56C14.1134 12.8334 13.8867 13.06 13.6134 13.06Z" fill="#0D0C23"></path>
                                            <path d="M11.5068 15.1666C11.3801 15.1666 11.2535 15.12 11.1535 15.02C10.9601 14.8267 10.9601 14.5066 11.1535 14.3133L12.9068 12.56L11.1535 10.8067C10.9601 10.6133 10.9601 10.2933 11.1535 10.1C11.3468 9.90665 11.6668 9.90665 11.8601 10.1L13.9668 12.2066C14.0601 12.3 14.1135 12.4267 14.1135 12.56C14.1135 12.6933 14.0601 12.82 13.9668 12.9133L11.8601 15.02C11.7668 15.12 11.6401 15.1666 11.5068 15.1666Z" fill="#0D0C23"></path>
                                        </svg>
                            </a>
                        </div>
                        <div class="enrol">
                            <div class="icon">
                              <span>
                                <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M6.66797 4.79166C6.3263 4.79166 6.04297 4.50832 6.04297 4.16666V1.66666C6.04297 1.32499 6.3263 1.04166 6.66797 1.04166C7.00964 1.04166 7.29297 1.32499 7.29297 1.66666V4.16666C7.29297 4.50832 7.00964 4.79166 6.66797 4.79166Z" fill="#68768B"/>
                                    <path d="M13.332 4.79166C12.9904 4.79166 12.707 4.50832 12.707 4.16666V1.66666C12.707 1.32499 12.9904 1.04166 13.332 1.04166C13.6737 1.04166 13.957 1.32499 13.957 1.66666V4.16666C13.957 4.50832 13.6737 4.79166 13.332 4.79166Z" fill="#68768B"/>
                                    <path d="M12.4987 9.79166H5.83203C5.49036 9.79166 5.20703 9.50832 5.20703 9.16666C5.20703 8.82499 5.49036 8.54166 5.83203 8.54166H12.4987C12.8404 8.54166 13.1237 8.82499 13.1237 9.16666C13.1237 9.50832 12.8404 9.79166 12.4987 9.79166Z" fill="#68768B"/>
                                    <path d="M9.9987 13.125H5.83203C5.49036 13.125 5.20703 12.8417 5.20703 12.5C5.20703 12.1583 5.49036 11.875 5.83203 11.875H9.9987C10.3404 11.875 10.6237 12.1583 10.6237 12.5C10.6237 12.8417 10.3404 13.125 9.9987 13.125Z" fill="#68768B"/>
                                    <path d="M12.5 18.9583H7.5C2.81667 18.9583 1.875 16.75 1.875 13.1833V8.04166C1.875 4.09166 3.20833 2.48332 6.63333 2.29166H13.3333C16.7917 2.48332 18.125 4.09166 18.125 8.04166V13.3333C18.125 13.675 17.8417 13.9583 17.5 13.9583C17.1583 13.9583 16.875 13.675 16.875 13.3333V8.04166C16.875 4.40832 15.6667 3.67499 13.3 3.54166H6.66667C4.33333 3.67499 3.125 4.40832 3.125 8.04166V13.1833C3.125 16.375 3.73333 17.7083 7.5 17.7083H12.5C12.8417 17.7083 13.125 17.9917 13.125 18.3333C13.125 18.675 12.8417 18.9583 12.5 18.9583Z" fill="#68768B"/>
                                    <path d="M12.5 18.9583C12.4167 18.9583 12.3417 18.9417 12.2583 18.9083C12.025 18.8083 11.875 18.5833 11.875 18.3333V15.8333C11.875 13.8167 12.9833 12.7083 15 12.7083H17.5C17.75 12.7083 17.9833 12.8583 18.075 13.0917C18.175 13.325 18.1167 13.5917 17.9417 13.775L12.9417 18.775C12.825 18.8917 12.6667 18.9583 12.5 18.9583ZM15 13.9583C13.6833 13.9583 13.125 14.5167 13.125 15.8333V16.825L15.9917 13.9583H15Z" fill="#68768B"/>
                                    </svg>
                              </span>
                                <h4><?php echo get_phrase('Lectures') ?></h4>
                            </div>
                            <h5><?php echo $this->db->get_where('lesson', ['course_id' => $course_details['id'], 'lesson_type !=' => 'quiz'])->num_rows(); ?></h5>
                        </div>

                        <?php $number_of_quiz = $this->db->get_where('lesson', ['course_id' => $course_details['id'], 'lesson_type' => 'quiz'])->num_rows(); ?>
                        <?php if ($number_of_quiz > 0) : ?>
                            <div class="enrol">
                                <div class="icon">
                                    <span>
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M17 4.5H16.5C16.5 3.229 15.771 2.5 14.5 2.5H9.5C8.229 2.5 7.5 3.229 7.5 4.5H7C4.71 4.5 3.5 5.71 3.5 8V18C3.5 20.29 4.71 21.5 7 21.5H17C19.29 21.5 20.5 20.29 20.5 18V8C20.5 5.71 19.29 4.5 17 4.5ZM8.5 4.5C8.5 3.78 8.78 3.5 9.5 3.5H14.5C15.22 3.5 15.5 3.78 15.5 4.5V5.5C15.5 6.22 15.22 6.5 14.5 6.5H9.5C8.78 6.5 8.5 6.22 8.5 5.5V4.5ZM19.5 18C19.5 19.729 18.729 20.5 17 20.5H7C5.271 20.5 4.5 19.729 4.5 18V8C4.5 6.271 5.271 5.5 7 5.5H7.5C7.5 6.771 8.229 7.5 9.5 7.5H14.5C15.771 7.5 16.5 6.771 16.5 5.5H17C18.729 5.5 19.5 6.271 19.5 8V18ZM15.5 12C15.5 12.276 15.276 12.5 15 12.5H9C8.724 12.5 8.5 12.276 8.5 12C8.5 11.724 8.724 11.5 9 11.5H15C15.276 11.5 15.5 11.724 15.5 12ZM13.5 16C13.5 16.276 13.276 16.5 13 16.5H9C8.724 16.5 8.5 16.276 8.5 16C8.5 15.724 8.724 15.5 9 15.5H13C13.276 15.5 13.5 15.724 13.5 16Z" fill="#25314C"/>
                                        </svg>
                                    </span>
                                    <h4><?php echo get_phrase('Quizzes') ?></h4>
                                </div>

                                <h5><?php echo $number_of_quiz; ?></h5>
                            </div>
                        <?php endif; ?>

                        <?php if($course_details['status'] == 'upcoming'):?>
                        <div class="enrol">
                            <div class="icon">
                                <span>
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M20.476 9.52599L20.0351 9.08498C19.8471 8.89598 19.742 8.64498 19.742 8.37798V7.75698C19.742 5.82798 18.1731 4.25899 16.2441 4.25899H15.6231C15.3601 4.25899 15.1021 4.15199 14.9161 3.96599L14.475 3.52498C13.112 2.16098 10.891 2.16098 9.528 3.52498L9.08709 3.96599C8.90009 4.15199 8.64306 4.25899 8.38006 4.25899H7.75908C5.83008 4.25899 4.26104 5.82798 4.26104 7.75698V8.37798C4.26104 8.64498 4.15707 8.89598 3.96807 9.08498L3.52703 9.52599C2.16303 10.89 2.16303 13.109 3.52703 14.473L3.96807 14.914C4.15507 15.1 4.26104 15.358 4.26104 15.621V16.242C4.26104 18.171 5.83008 19.74 7.75908 19.74H8.38006C8.64406 19.74 8.90109 19.847 9.08709 20.033L9.528 20.474C10.21 21.156 11.106 21.497 12.002 21.497C12.898 21.497 13.794 21.156 14.476 20.474L14.917 20.033C15.104 19.847 15.3601 19.74 15.6241 19.74H16.245C18.174 19.74 19.7431 18.171 19.7431 16.242V15.621C19.7431 15.358 19.8491 15.1 20.0361 14.914L20.4771 14.473C21.8401 13.11 21.84 10.89 20.476 9.52599ZM19.7691 13.767L19.3281 14.208C18.9501 14.586 18.742 15.088 18.742 15.622V16.243C18.742 17.62 17.6211 18.741 16.2441 18.741H15.6231C15.0971 18.741 14.581 18.955 14.209 19.327L13.768 19.768C12.825 20.712 11.178 20.712 10.235 19.768L9.794 19.327C9.422 18.955 8.90606 18.741 8.38006 18.741H7.75908C6.38208 18.741 5.26104 17.62 5.26104 16.243V15.622C5.26104 15.088 5.0531 14.586 4.6751 14.208L4.23406 13.767C3.76206 13.295 3.5031 12.668 3.5031 12C3.5031 11.332 3.76306 10.705 4.23406 10.233L4.6751 9.79198C5.0531 9.41398 5.26104 8.91198 5.26104 8.37798V7.75698C5.26104 6.37998 6.38208 5.25899 7.75908 5.25899H8.38006C8.90606 5.25899 9.422 5.04499 9.794 4.67299L10.235 4.23198C11.178 3.28798 12.825 3.28798 13.768 4.23198L14.209 4.67299C14.581 5.04499 15.0971 5.25899 15.6231 5.25899H16.2441C17.6211 5.25899 18.742 6.37998 18.742 7.75698V8.37798C18.742 8.91198 18.9501 9.41498 19.3281 9.79198L19.7691 10.233C20.2411 10.705 20.5001 11.332 20.5001 12C20.5001 12.668 20.2401 13.295 19.7691 13.767ZM15.3541 9.64599C15.5491 9.84099 15.5491 10.158 15.3541 10.353L11.3541 14.353C11.2561 14.451 11.1281 14.499 11.0001 14.499C10.8721 14.499 10.744 14.45 10.646 14.353L8.64605 12.353C8.45105 12.158 8.45105 11.841 8.64605 11.646C8.84105 11.451 9.15808 11.451 9.35308 11.646L10.9991 13.292L14.6451 9.64599C14.8421 9.45099 15.1581 9.45099 15.3541 9.64599Z" fill="#25314C"/>
                                    </svg>
                                </span>
                                <h4><?php echo get_phrase('Category') ?></h4>
                            </div>
                            <h5><?php echo $this->db->where('id', $course_details['sub_category_id'])->get('category')->row('name'); ?></h5>
                        </div>
                        <?php if($course_details['publish_date']):?>
                        <div class="enrol">
                            <div class="icon">
                               <span>
                                 <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M18 4H16.5V3C16.5 2.724 16.276 2.5 16 2.5C15.724 2.5 15.5 2.724 15.5 3V4H8.5V3C8.5 2.724 8.276 2.5 8 2.5C7.724 2.5 7.5 2.724 7.5 3V4H6C3.71 4 2.5 5.21 2.5 7.5V18C2.5 20.29 3.71 21.5 6 21.5H18C20.29 21.5 21.5 20.29 21.5 18V7.5C21.5 5.21 20.29 4 18 4ZM6 5H7.5V6C7.5 6.276 7.724 6.5 8 6.5C8.276 6.5 8.5 6.276 8.5 6V5H15.5V6C15.5 6.276 15.724 6.5 16 6.5C16.276 6.5 16.5 6.276 16.5 6V5H18C19.729 5 20.5 5.771 20.5 7.5V8.5H3.5V7.5C3.5 5.771 4.271 5 6 5ZM18 20.5H6C4.271 20.5 3.5 19.729 3.5 18V9.5H20.5V18C20.5 19.729 19.729 20.5 18 20.5ZM8.75 13C8.75 13.415 8.41591 13.75 8.00391 13.75C7.59291 13.75 7.25 13.415 7.25 13C7.25 12.585 7.57701 12.25 7.98901 12.25H8.00391C8.41591 12.25 8.75 12.585 8.75 13ZM12.75 13C12.75 13.415 12.4159 13.75 12.0039 13.75C11.5929 13.75 11.25 13.415 11.25 13C11.25 12.585 11.577 12.25 11.989 12.25H12.0039C12.4159 12.25 12.75 12.585 12.75 13ZM16.75 13C16.75 13.415 16.4159 13.75 16.0039 13.75C15.5929 13.75 15.25 13.415 15.25 13C15.25 12.585 15.577 12.25 15.989 12.25H16.0039C16.4159 12.25 16.75 12.585 16.75 13ZM8.75 17C8.75 17.415 8.41591 17.75 8.00391 17.75C7.59291 17.75 7.25 17.415 7.25 17C7.25 16.585 7.57701 16.25 7.98901 16.25H8.00391C8.41591 16.25 8.75 16.585 8.75 17ZM12.75 17C12.75 17.415 12.4159 17.75 12.0039 17.75C11.5929 17.75 11.25 17.415 11.25 17C11.25 16.585 11.577 16.25 11.989 16.25H12.0039C12.4159 16.25 12.75 16.585 12.75 17ZM16.75 17C16.75 17.415 16.4159 17.75 16.0039 17.75C15.5929 17.75 15.25 17.415 15.25 17C15.25 16.585 15.577 16.25 15.989 16.25H16.0039C16.4159 16.25 16.75 16.585 16.75 17Z" fill="#25314C"/>
                                    </svg>
                               </span>
                                <h4><?php echo get_phrase('Publish Date') ?></h4>
                            </div>
                            <h5><?php echo date('j F Y', strtotime($course_details['publish_date'])); ?></h5>
                        </div>
                        <?php endif; else:?>
                        <div class="enrol">
                            <div class="icon">
                                <span>
                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M4.9615 13.2806L4.96146 13.2806C4.75771 13.4841 4.4285 13.4843 4.22457 13.2811C4.01578 13.0773 4.01577 12.7473 4.22453 12.5435L7.46622 9.3019L7.46627 9.30185C7.99984 8.76899 8.86616 8.76896 9.39977 9.30176C9.3998 9.30179 9.39983 9.30182 9.39987 9.30185L10.702 10.5981L4.9615 13.2806ZM4.9615 13.2806L8.20316 10.039M4.9615 13.2806L8.20316 10.039M15.3274 6.56669C15.6627 6.56669 15.9346 6.83802 15.9346 7.17326V8.89981C15.9346 9.18735 15.6995 9.42196 15.4119 9.42196C15.1243 9.42196 14.8892 9.18735 14.8892 8.89981V8.34715L11.8938 11.3346L11.8938 11.3346M15.3274 6.56669L8.73319 9.96783L10.0309 11.2638C10.5255 11.7577 11.3286 11.7577 11.8232 11.2638L11.8938 11.3346M15.3274 6.56669H13.5985C13.3067 6.56669 13.0758 6.79707 13.0758 7.08883C13.0758 7.37571 13.3061 7.61097 13.5985 7.61097H14.1473M15.3274 6.56669L14.1473 7.61097M11.8938 11.3346C11.3602 11.8675 10.4938 11.8674 9.96023 11.3346L8.66252 10.0386C8.53734 9.91357 8.33393 9.91216 8.20316 10.039M11.8938 11.3346L8.20316 10.039M14.1473 7.61097L11.1565 10.5978C11.0312 10.723 10.828 10.7231 10.7021 10.5981L14.1473 7.61097Z" fill="#68768B" stroke="#68768B" stroke-width="0.2"/>
                                    <path d="M12.5013 18.9584H7.5013C2.9763 18.9584 1.04297 17.025 1.04297 12.5V7.50002C1.04297 2.97502 2.9763 1.04169 7.5013 1.04169H12.5013C17.0263 1.04169 18.9596 2.97502 18.9596 7.50002V12.5C18.9596 17.025 17.0263 18.9584 12.5013 18.9584ZM7.5013 2.29169C3.65963 2.29169 2.29297 3.65835 2.29297 7.50002V12.5C2.29297 16.3417 3.65963 17.7084 7.5013 17.7084H12.5013C16.343 17.7084 17.7096 16.3417 17.7096 12.5V7.50002C17.7096 3.65835 16.343 2.29169 12.5013 2.29169H7.5013Z" fill="#68768B"/>
                                    </svg>

                                </span>
                                <h4><?php echo get_phrase('Skill level') ?></h4>
                            </div>
                            <h5><?php echo get_phrase($course_details['level']); ?></h5>
                        </div>
                        <?php endif;?>


                        <div class="enrol">
                            <div class="icon">
                                <span>
                                  <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M14.4835 17.2917H9.0918C8.75013 17.2917 8.4668 17.0083 8.4668 16.6667C8.4668 16.325 8.75013 16.0417 9.0918 16.0417H14.4835C17.0335 16.0417 17.6335 15.625 17.7001 13.3583C16.6001 13.075 15.7835 12.075 15.7835 10.8917C15.7835 9.70001 16.6001 8.69167 17.7085 8.40834V8.19167C17.7085 5.45001 17.2251 4.96667 14.4835 4.96667H9.7918V10C9.7918 10.3417 9.50846 10.625 9.1668 10.625C8.82513 10.625 8.5418 10.3417 8.5418 10V4.34167C8.5418 4.00001 8.82513 3.71667 9.1668 3.71667H14.4835C17.9168 3.71667 18.9585 4.75834 18.9585 8.19167V8.95834C18.9585 9.30001 18.6751 9.58334 18.3335 9.58334C17.6168 9.58334 17.0335 10.1667 17.0335 10.8917C17.0335 11.6083 17.6168 12.1917 18.3335 12.1917C18.6751 12.1917 18.9585 12.475 18.9585 12.8167C18.9585 16.25 17.9168 17.2917 14.4835 17.2917Z" fill="#68768B"/>
                                        <path d="M9.16801 17.2917H6.85967C5.17634 17.2917 4.30967 16.025 3.51801 14.125L3.35967 13.7417C3.30134 13.5917 3.30134 13.4167 3.36801 13.2667C3.43467 13.1167 3.55967 12.9917 3.70967 12.9333C4.04301 12.8 4.30134 12.5417 4.44301 12.2167C4.58467 11.8833 4.58467 11.5167 4.44301 11.1833C4.16801 10.4833 3.37634 10.1583 2.67634 10.4333C2.51801 10.5 2.35134 10.4917 2.19301 10.425C2.04301 10.3583 1.91801 10.2333 1.85967 10.0833L1.71801 9.725C0.384673 6.48333 0.968007 5.09166 4.20967 3.75L6.40967 2.85C6.72634 2.71666 7.09301 2.875 7.22634 3.19166L9.75134 9.30833C9.78467 9.38333 9.80134 9.46666 9.80134 9.55V11.6667C9.80134 12.0083 9.51801 12.2917 9.17634 12.2917C8.83467 12.2917 8.55134 12.0083 8.55134 11.6667V9.66666L6.30134 4.24166L4.68467 4.90833C2.11801 5.96666 1.80967 6.61666 2.81801 9.11666C3.97634 8.95 5.14301 9.575 5.60134 10.7C5.86801 11.3417 5.86801 12.05 5.59301 12.6917C5.40967 13.1333 5.10967 13.5083 4.72634 13.7833C5.52634 15.6667 6.10967 16.0417 6.85134 16.0417H8.53467V14.1667C8.53467 13.825 8.81801 13.5417 9.15967 13.5417C9.50134 13.5417 9.78467 13.825 9.78467 14.1667V16.6667C9.79301 17.0083 9.50967 17.2917 9.16801 17.2917Z" fill="#68768B"/>
                                        <path d="M6.80964 17.2917H6.66797C6.3263 17.2917 6.04297 17.0084 6.04297 16.6667C6.04297 16.325 6.3263 16.0417 6.66797 16.0417H6.80964C7.1513 16.0417 7.43464 16.325 7.43464 16.6667C7.43464 17.0084 7.1513 17.2917 6.80964 17.2917Z" fill="#68768B"/>
                                        </svg>
                                </span>
                                <h4><?php echo get_phrase('Expiry period') ?></h4>
                            </div>
                            <h5>
                                <?php if ($course_details['expiry_period'] <= 0) : ?>
                                    <?php echo get_phrase('Lifetime') ?>
                                <?php else : ?>
                                    <?php echo $course_details['expiry_period'] . ' ' . get_phrase('Months'); ?>
                                <?php endif; ?>
                            </h5>
                        </div>

                        <?php if (addon_status('certificate')) : ?>
                            <div class="enrol">
                                <div class="icon">
                                    <span>
                                          <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M10.0008 18.9584C9.50078 18.9584 9.00911 18.8417 8.60911 18.6167L4.66745 16.3417C3.03411 15.2417 2.92578 15.0417 2.92578 13.3167V9.18336C2.92578 7.45836 3.03411 7.25836 4.63411 6.18336L8.61745 3.88336C9.40911 3.42503 10.6008 3.42503 11.3924 3.88336L15.3341 6.15836C16.9674 7.25836 17.0758 7.45836 17.0758 9.18336V13.3167C17.0758 15.0417 16.9674 15.2417 15.3674 16.3167L11.3841 18.6167C10.9924 18.85 10.4924 18.9584 10.0008 18.9584ZM10.0008 4.7917C9.71745 4.7917 9.43411 4.85003 9.23411 4.9667L5.29245 7.24169C4.17578 8.00003 4.17578 8.00003 4.17578 9.18336V13.3167C4.17578 14.5 4.17578 14.5 5.33411 15.2834L9.24245 17.5334C9.64245 17.7667 10.3674 17.7667 10.7674 17.5334L14.7091 15.2584C15.8258 14.5 15.8258 14.5 15.8258 13.3167V9.18336C15.8258 8.00003 15.8258 8.00003 14.6674 7.2167L10.7591 4.9667C10.5674 4.85003 10.2841 4.7917 10.0008 4.7917Z" fill="#68768B"/>
                                            <path d="M14.5846 6.98335C14.243 6.98335 13.9596 6.70002 13.9596 6.35835V4.16669C13.9596 2.85002 13.4013 2.29169 12.0846 2.29169H7.91797C6.6013 2.29169 6.04297 2.85002 6.04297 4.16669V6.30002C6.04297 6.64169 5.75964 6.92502 5.41797 6.92502C5.0763 6.92502 4.79297 6.65002 4.79297 6.30002V4.16669C4.79297 2.15002 5.9013 1.04169 7.91797 1.04169H12.0846C14.1013 1.04169 15.2096 2.15002 15.2096 4.16669V6.35835C15.2096 6.70002 14.9263 6.98335 14.5846 6.98335Z" fill="#68768B"/>
                                            <path d="M11.3569 14.6916C11.1819 14.6916 10.9986 14.6583 10.8152 14.5833L9.99857 14.2666L9.1819 14.5916C8.74024 14.7666 8.29024 14.725 7.9569 14.4833C7.62357 14.2416 7.44857 13.825 7.47357 13.35L7.52357 12.475L6.96524 11.8C6.66524 11.425 6.56524 10.9916 6.69857 10.5916C6.82357 10.2 7.16524 9.89998 7.62357 9.78331L8.47357 9.56664L8.94857 8.82498C9.4569 8.02498 10.5486 8.02498 11.0569 8.82498L11.5319 9.56664L12.3819 9.78331C12.8402 9.89998 13.1819 10.2 13.3069 10.5916C13.4319 10.9833 13.3319 11.425 13.0319 11.7916L12.4736 12.4666L12.5236 13.3416C12.5486 13.8166 12.3736 14.225 12.0402 14.475C11.8402 14.6166 11.6069 14.6916 11.3569 14.6916ZM7.9319 11L8.49024 11.675C8.6819 11.9 8.79024 12.2583 8.77357 12.55L8.72357 13.425L9.54024 13.1C9.81524 12.9916 10.1819 12.9916 10.4569 13.1L11.2736 13.425L11.2236 12.55C11.2069 12.2583 11.3152 11.9083 11.5069 11.675L12.0652 11L11.2152 10.7833C10.9319 10.7083 10.6319 10.4916 10.4736 10.25L10.0069 9.51664L9.5319 10.25C9.37357 10.5 9.07357 10.7166 8.79024 10.7916L7.9319 11Z" fill="#68768B"/>
                                            </svg>

                                    </span>
                                    <h4><?php echo get_phrase('Certificate') ?></h4>
                                </div>

                                <h5><?php echo get_phrase('Yes') ?></h5>
                            </div>
                        <?php endif; ?>


                        <!-- button -->
                        <div class="button">
                            <?php $cart_items = $this->session->userdata('cart_items'); ?>
                            <?php if (is_purchased($course_details['id'])) : ?>
                                <a href="<?php echo site_url('home/lesson/' . slugify($course_details['title']) . '/' . $course_details['id']) ?>"><i class="far fa-play-circle"></i> <?php echo get_phrase('Start Now'); ?></a>
                                <?php if ($course_details['is_free_course'] != 1) : ?>
                                    <a href="#" onclick="actionTo('<?php echo site_url('home/handle_buy_now/' . $course_details['id'] . '?gift=1'); ?>')"><i class="fas fa-gift"></i> <?php echo get_phrase('Gift someone else'); ?></a>
                                <?php endif; ?>
                            <?php else : ?>
                                <?php if ($course_details['is_free_course'] == 1) : ?>
                                    <a href="<?php echo site_url('home/get_enrolled_to_free_course/' . $course_details['id']); ?>"><?php echo get_phrase('Enroll Now'); ?></a>
                                <?php else : ?>

                                    <!-- Cart button -->
                                    <a id="added_to_cart_btn_<?php echo $course_details['id']; ?>" class="<?php if (!in_array($course_details['id'], $cart_items)) echo 'd-hidden'; ?> active" href="#" onclick="actionTo('<?php echo site_url('home/handle_cart_items/' . $course_details['id']); ?>');"><i class="fas fa-minus"></i> <?php echo get_phrase('Remove from cart'); ?></a>
                                    <a id="add_to_cart_btn_<?php echo $course_details['id']; ?>" class="<?php if (in_array($course_details['id'], $cart_items)) echo 'd-hidden'; ?>" href="#" onclick="actionTo('<?php echo site_url('home/handle_cart_items/' . $course_details['id']); ?>'); "><i class="fas fa-plus"></i> <?php echo get_phrase('Add to cart'); ?></a>
                                    <!-- Cart button ended-->

                                    <a href="#" onclick="actionTo('<?php echo site_url('home/handle_buy_now/' . $course_details['id']); ?>')"><i class="fas fa-credit-card"></i> <?php echo get_phrase('Buy Now'); ?></a>
                                <?php endif; ?>
                            <?php endif; ?>

                            <?php if (addon_status('affiliate_course')) : // course_addon start  adding
                                $CI    = &get_instance();
                                $CI->load->model('addons/affiliate_course_model');
                                $is_affiliattor = $CI->affiliate_course_model->is_affilator($this->session->userdata('user_id'));
                                if ($is_affiliattor == 1) :
                                    $user_data = $CI->affiliate_course_model->get__affiliator_status_table_info_by_user_id($this->session->userdata('user_id'));
                            ?>

                                    <a class="btn-custom_coursepage text-decoration-none fw-600 hover-shadow-1 d-inline-block" href="#myModel" data-bs-toggle="modal" data-bs-target="#myModel" id="shareBtn" data-bs-placement="top"><i class="fas fa-user-plus"></i> <?php echo site_phrase('Share and Earn'); ?></a>

                                <?php endif; ?>
                            <?php endif; ?>
                        </div>


                        <?php
                        if (isset($user_data['unique_identifier'])) :
                            $ref = $user_data['unique_identifier'];
                        else :
                            $ref = '';
                        endif;
                        ?>
                    </div>
                    <div class="eSocialShare d-flex align-items-center w-100">
                            <?php $share_url = site_url('home/course/' . slugify($course_details['title']) . '/' . $course_details['id']); ?>
                            <p><?php echo  site_phrase('Share this course');?></p>
                            <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo $share_url; ?>&ref=<?php echo $ref; ?>" target="_blank" class="p-2" style="color: #316FF6;" data-bs-toggle="tooltip" title="<?php echo get_phrase('Share on Facebook'); ?>" data-bs-placement="top">
                                <svg width="19" height="19" viewBox="0 0 19 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <g clip-path="url(#clip0_30_3727)">
                                    <path d="M18.902 8.99994C18.902 4.02941 14.6706 0 9.45099 0C4.23135 0 0 4.02941 0 8.99994C0 13.492 3.45607 17.2154 7.97427 17.8905V11.6015H5.57461V8.99994H7.97427V7.01714C7.97427 4.76153 9.38528 3.5156 11.5441 3.5156C12.5778 3.5156 13.6596 3.69138 13.6596 3.69138V5.90621H12.4679C11.2939 5.90621 10.9277 6.60001 10.9277 7.31245V8.99994H13.5489L13.1299 11.6015H10.9277V17.8905C15.4459 17.2154 18.902 13.492 18.902 8.99994Z" fill="#000"/>
                                    </g>
                                    <defs>
                                    <clipPath id="clip0_30_3727">
                                    <rect width="18.902" height="17.9999" fill="white"/>
                                    </clipPath>
                                    </defs>
                             </svg>
                            </a>
                            <a href="https://twitter.com/intent/tweet?url=<?php echo $share_url; ?>&text=<?php echo $course_details['title']; ?>&ref=<?php echo $ref; ?>" target="_blank" class="p-2" style="color: #1DA1F2;" data-bs-toggle="tooltip" title="<?php echo get_phrase('Share on Twitter'); ?>" data-bs-placement="top">
                            <svg width="19" height="19" viewBox="0 0 20 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0_30_3730)">
                                <path d="M11.2841 7.5801L18.2156 0H16.5731L10.5545 6.5817L5.74746 0H0.203125L7.47229 9.95269L0.203125 17.9016H1.84575L8.20153 10.9511L13.2781 17.9016H18.8224L11.2837 7.5801H11.2841ZM9.03434 10.0404L8.29782 9.04931L2.43761 1.16331H4.96059L9.68985 7.52757L10.4264 8.51863L16.5738 16.7912H14.0509L9.03434 10.0408V10.0404Z" fill="#0D0C23"/>
                                </g>
                                <defs>
                                <clipPath id="clip0_30_3730">
                                <rect width="19.0285" height="17.9016" fill="white"/>
                                </clipPath>
                                </defs>
                                </svg>

                            </a>
                            <a href="https://api.whatsapp.com/send?text=<?php echo $share_url; ?>&ref=<?php echo $ref; ?>" target="_blank" class="p-2" style="color: #128c7e;" data-bs-toggle="tooltip" title="<?php echo get_phrase('Share on Whatsapp'); ?>" data-bs-placement="top">
                                <i class="fab fa-whatsapp text-20px dark"></i>
                            </a>
                            <a href="https://www.linkedin.com/shareArticle?url=<?php echo $share_url; ?>&title=<?php echo $course_details['title']; ?>&summary=<?php echo $course_details['short_description']; ?>&ref=<?php echo $ref; ?>" target="_blank" class="p-2" style="color: #0077b5;" data-bs-toggle="tooltip" title="<?php echo get_phrase('Share on Linkedin'); ?>" data-bs-placement="top">
                            <svg width="19" height="19" viewBox="0 0 19 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0_30_3738)">
                                <path d="M17.5028 0H1.3955C0.623913 0 0 0.580074 0 1.29726V16.6991C0 17.4163 0.623913 17.9999 1.3955 17.9999H17.5028C18.2744 17.9999 18.902 17.4163 18.902 16.7026V1.29726C18.902 0.580074 18.2744 0 17.5028 0ZM5.60783 15.3386H2.80207V6.74644H5.60783V15.3386ZM4.20495 5.57574C3.30416 5.57574 2.57687 4.88317 2.57687 4.02888C2.57687 3.17459 3.30416 2.48201 4.20495 2.48201C5.10206 2.48201 5.82934 3.17459 5.82934 4.02888C5.82934 4.87965 5.10206 5.57574 4.20495 5.57574ZM16.1073 15.3386H13.3052V11.162C13.3052 10.1671 13.2868 8.88392 11.847 8.88392C10.3887 8.88392 10.1672 9.97025 10.1672 11.0917V15.3386H7.36882V6.74644H10.0564V7.92065H10.0934C10.4662 7.24565 11.3818 6.53199 12.7441 6.53199C15.5831 6.53199 16.1073 8.31088 16.1073 10.6241V15.3386Z" fill="#000"/>
                                </g>
                                <defs>
                                <clipPath id="clip0_30_3738">
                                <rect width="18.902" height="17.9999" rx="2" fill="white"/>
                                </clipPath>
                                </defs>
                                </svg>

                            </a>
                           
                        </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--------- course Decription Page end ------>

<!-------- Related course section start ----->
<section class="courses grid-view-body course-details-card mt-5">
    <div class="container">
        <h1><?php echo get_phrase('Related Courses'); ?></h1>
        <div class="courses-card mt-5">
            <div class="row">
                <?php $related_courses = $this->crud_model->get_related_courses($course_details['category_id'], $course_details['sub_category_id'], $course_details['id'], 12)->result_array(); ?>
                <?php foreach ($related_courses as $key => $course) :

                    $lessons = $this->crud_model->get_lessons('course', $course['id']);
                    $instructor_details = $this->user_model->get_all_user($course['user_id'])->row_array();
                    $course_duration = $this->crud_model->get_total_duration_of_lesson_by_course_id($course['id']);
                    $total_rating =  $this->crud_model->get_ratings('course', $course['id'], true)->row()->rating;
                    $number_of_ratings = $this->crud_model->get_ratings('course', $course['id'])->num_rows();
                    if ($number_of_ratings > 0) {
                        $average_ceil_rating = ceil($total_rating / $number_of_ratings);
                    } else {
                        $average_ceil_rating = 0;
                    }
                ?>
                    <div class="col-lg-3 col-md-4 col-sm-6 col-12">
                        <a href="<?php echo site_url('home/course/' . rawurlencode(slugify($course['title'])) . '/' . $course['id']); ?>" class="checkPropagation eGridCourse  courses-card-body epopCourse  position-relative">
                            <div class="courses-card-image">
                                <img loading="lazy" src="<?php echo $this->crud_model->get_course_thumbnail_url($course['id']); ?>">
                                <div class="courses-icon <?php if (in_array($course['id'], $my_wishlist_items)) echo 'red-heart'; ?>" id="coursesWishlistIcon<?php echo $course['id']; ?>">
                                    <i class="fa-solid fa-heart checkPropagation" onclick="actionTo('<?php echo site_url('home/toggleWishlistItems/' . $course['id']); ?>')"></i>
                                </div>
                                <div class="courses-card-image-text">
                                    <h3><?php echo get_phrase($course['level']); ?></h3>
                                </div>
                            </div>
                            <div class="courses-text">
                                <h5 class="mb-2"><?php echo $course['title']; ?></h5>
                                <div class="review-icon">
                                        <div class="review-icon-star align-item-center">
                                        <p><i class="fa-solid fa-star <?php if ($number_of_ratings > 0) echo 'filled'; ?>"></i></p>
                                            <p class="mr-5px"><?php echo $average_ceil_rating; ?></p>
                                            <p>(<?php echo $number_of_ratings; ?> <?php echo get_phrase('Reviews') ?>)</p>
                                        </div>
                                    <div class="review-btn">
                                        <span data-bs-toggle="tooltip" data-bs-title="<?php echo site_phrase('Compare')?>" class="compare-img echecks  checkPropagation" onclick="redirectTo('<?php echo base_url('home/compare?course-1=' . slugify($course['title']) . '&course-id-1=' . $course['id']); ?>');">
                                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M13.6134 8.14665C13.3401 8.14665 13.1134 7.91998 13.1134 7.64665V5.43335C13.1134 4.60668 12.4401 3.93335 11.6134 3.93335H2.38672C2.11339 3.93335 1.88672 3.70668 1.88672 3.43335C1.88672 3.16002 2.11339 2.93335 2.38672 2.93335H11.6134C12.9934 2.93335 14.1134 4.05335 14.1134 5.43335V7.64665C14.1134 7.92665 13.8867 8.14665 13.6134 8.14665Z" fill="#0D0C23"/>
                                            <path d="M4.49339 6.04665C4.36672 6.04665 4.24006 5.99996 4.14006 5.89996L2.03339 3.79332C1.94005 3.69998 1.88672 3.5733 1.88672 3.43996C1.88672 3.30663 1.94005 3.17998 2.03339 3.08665L4.14006 0.979961C4.33339 0.786628 4.65339 0.786628 4.84672 0.979961C5.04005 1.17329 5.04005 1.49333 4.84672 1.68667L3.0934 3.43996L4.84672 5.1933C5.04005 5.38663 5.04005 5.70663 4.84672 5.89996C4.74672 5.9933 4.62005 6.04665 4.49339 6.04665Z" fill="#0D0C23"/>
                                            <path d="M13.6134 13.06H4.38672C3.00672 13.06 1.88672 11.94 1.88672 10.56V8.34668C1.88672 8.07335 2.11339 7.84668 2.38672 7.84668C2.66005 7.84668 2.88672 8.07335 2.88672 8.34668V10.56C2.88672 11.3867 3.56005 12.06 4.38672 12.06H13.6134C13.8867 12.06 14.1134 12.2867 14.1134 12.56C14.1134 12.8334 13.8867 13.06 13.6134 13.06Z" fill="#0D0C23"/>
                                            <path d="M11.5068 15.1666C11.3801 15.1666 11.2535 15.12 11.1535 15.02C10.9601 14.8267 10.9601 14.5066 11.1535 14.3133L12.9068 12.56L11.1535 10.8067C10.9601 10.6133 10.9601 10.2933 11.1535 10.1C11.3468 9.90665 11.6668 9.90665 11.8601 10.1L13.9668 12.2066C14.0601 12.3 14.1135 12.4267 14.1135 12.56C14.1135 12.6933 14.0601 12.82 13.9668 12.9133L11.8601 15.02C11.7668 15.12 11.6401 15.1666 11.5068 15.1666Z" fill="#0D0C23"/>
                                        </svg>
                                        </span>
                                    </div>
                                </div>
                                 <!--  -->
                                 <div class="duration-time">
                                    <?php if($course_duration): ?>
                                    <p class="m-0"> 
                                        <i class="fa-regular fa-clock p-0 text-15px"></i> <?php echo $course_duration; ?></p>
                                    <?php endif; ?>
                                </div>
                                <!--  -->
                                <!-- <p class="ellipsis-line-2 mx-0"><?php echo $course['short_description']; ?></p> -->
                                <div class="courses-price-border">
                                    <div class="courses-price">
                                        <div class="courses-price-left">
                                            <?php if ($course['is_free_course']) : ?>
                                                <h5><?php echo get_phrase('Free'); ?></h5>
                                            <?php elseif ($course['discount_flag']) : ?>
                                                <h5><?php echo currency($course['discounted_price']); ?></h5>
                                                <p class="mt-1"><del><?php echo currency($course['price']); ?></del></p>
                                            <?php else : ?>
                                                <h5><?php echo currency($course['price']); ?></h5>
                                            <?php endif; ?>
                                        </div>
                                        <div class="courses-price-right ">
                                          <?php if(is_purchased($course['id'])): ?>
                                                <span class="enrollBtn"><i class="far fa-play-circle text-white"></i> <?php echo get_phrase('Start Now'); ?></span>
                                              <?php else: ?>
                                           <span class="enrollBtn"><?php echo site_phrase('Enroll Now')?></span>
                                           <?php endif; ?>
                                         </div>
                                    </div>
                                </div>
                            </div>
                        </a>
                    </div>
                <?php endforeach ?>
            </div>
        </div>
    </div>
</section>
<!-------- Related course section end ----->


<?php if (addon_status('affiliate_course') && $is_affiliattor == 1) : ?>
    <?php include 'affiliate_course_modal.php';  // course_addon  single line /adding 
    ?>
<?php endif; ?>

<?php if (addon_status('team_training')) : ?>
    <?php include 'course_related_packages.php'; ?>
<?php endif; ?>