<?php
$course_details = $this->crud_model->get_course_by_id($course_id)->row_array();
$lessons = $this->crud_model->get_lessons('course', $course_details['id']);
$instructor_details = $this->user_model->get_all_user($course_details['creator'])->row_array();
$course_duration = $this->crud_model->get_total_duration_of_lesson_by_course_id($course_details['id']);
$number_of_enrolments = $this->crud_model->enrol_history($course_details['id'])->num_rows();
$total_rating =  $this->crud_model->get_ratings('course', $course_details['id'], true)->row()->rating;
$number_of_ratings = $this->crud_model->get_ratings('course', $course_details['id'])->num_rows();
if ($number_of_ratings > 0) {
    $average_ceil_rating = ceil($total_rating / $number_of_ratings);
} else {
    $average_ceil_rating = 0;
}
?>

<section class="bd-breadcrumb-area p-relative fix z-index-11" style="background-color:#f38222; margin-top:20px">
            <div class="bd-breadcrumb-bg-two" ></div>
            <div class="bd-breadcrumb-wrapper p-relative">
                <div class="container">
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="bd-breadcrumb style-two d-flex-center" style="padding-top:20px">
                                <div class="bd-breadcrumb-content">
                                    <h1 class="bd-breadcrumb-title"><?php echo $course_details['title']; ?></h1>
                                    <div class="bd-breadcrumb-list">
                                        <span><a href="<?php echo base_url();?>">Home</a></span>
                                        <span class="divider"><i class="fa-regular fa-angle-right"></i></span>
                                        <span class="active"><?php echo $course_details['title']; ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                </div>
            </div>
        </section>
        
   <section class="bd-course-details-area bd-course-details-top section-space-bottom">
            <div class="container">
                <div class="row gy-30">
                    <div class="col-xxl-8 col-xl-8 col-lg-8">
                        <div class="bd-course-details-wrapper mb-30">
                            <div class="bd-course-details-heading mb-30">
                                <h2 class="bd-course-details-title mb-5"><?php echo $course_details['title']; ?></h2>
                                <div class="bd-course-details-rating">
                                    <ul>
                                         <?php for ($i = 1; $i < 6; $i++) : ?>
                                                    <?php if ($i <= $average_ceil_rating) : ?>
                                                        <li class="me-0"><i class="fa-solid fa-star text-15px  mt-7px"></i></li>
                                                    <?php else : ?>
                                                        <li class="me-0"><i class="fa-solid fa-star text-shadow text-15px  mt-7px"></i></li>
                                                    <?php endif; ?>
                                                <?php endfor; ?>
                                     </ul>
                                    <span>(<?php echo $number_of_ratings;?> reviews)</span>
                                </div>
                            </div>
                            <div class="bd-course-details-meta mb-30">
                                <div class="bd-course-author border-line-meta">
                                   
                                    <div class="authour-meta">
                                        <span class="subtitle">Created by</span>
                                        <div class="name"><a href="#">SystemPlus</a></div>
                                    </div>
                                </div>
                                <div class="bd-course-details-meta-item border-line-meta">
                                    <p class="title">Total Enrolled</p>
                                    <span class="subtitle"><?php echo $number_of_enrolments ?></span>
                                </div>
                                <div class="bd-course-details-meta-item border-line-meta">
                                    <p class="title">Last Update</p>
                                    <?php if ($course_details['last_modified'] > 0) : ?>
                                                <span class="subtitle"> <?php echo date('D, d-M-Y', $course_details['last_modified']); ?></span>
                                            <?php else : ?>
                                             <span class="subtitle"> <?php echo date('D, d-M-Y', $course_details['date_added']); ?></span>
                                             <?php endif; ?>
                                   
                                </div>
                                <div class="bd-course-details-meta-item">
                                    <p class="title">Language</p>
                                    <span class="subtitle"><a href="#"><?php echo ucfirst($course_details['language']); ?></a></span>
                                </div>
                            </div>
                            <div class="bd-course-details-content mb-30">
                                <h3 class="bd-course-details-content-title">Description</h3>
                                <p class="description"><?php echo $course_details['description']; ?></p>
                            </div>
                            <div class="bd-course-details-content mb-30">
                                <h3 class="bd-course-details-content-title">Course Overview</h3>
                                <div class="bd-course-details-list-box">
                                    <div class="bd-course-details-list">
                                        <?php $course_outcomes = json_decode($course_details['outcomes'], true); ?>
<?php if(count($course_outcomes) > 0){ ?>
<ul>
                                        <?php foreach($course_outcomes as $key => $faq): ?>
                                            
                                            <li>
                                                <span class="list-icon success">
                                       <i class="fa-solid fa-check"></i>
                                    </span>
                                                <?php echo $faq; ?>
                                            </li>
                                      <?php endforeach; ?>
                    <?php } ?>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="bd-course-details-content mb-30">
                                <h3 class="bd-course-details-content-title">Requirements</h3>
                                <div class="bd-post-details-list">
                                   <?php $course_requirements = json_decode($course_details['requirements'], true); ?>
<?php if(count($course_requirements) > 0){ ?>
<ul>
                                        <?php foreach($course_requirements as $key => $faq): ?>
                                        <li>
                                            <?php echo $faq; ?>
                                        </li>
                            <?php endforeach; ?>
                    <?php } ?>
                                    </ul>
                                </div>
                            </div>
                            
                            <div class="bd-course-details-content mb-30">
                                <h3 class="bd-course-details-content-title">Course Faqs</h3>
                                <div class="bd-post-details-list">
                                   <?php $course_faqs = json_decode($course_details['faqs'], true); ?>
<?php if(count($course_faqs) > 0){ ?>
<ul>
                                        <?php foreach($course_faqs as $key => $faq): ?>
                                        <li>
                                            <?php echo $faq; ?>
                                        </li>
                            <?php endforeach; ?>
                    <?php } ?>
                                    </ul>
                                </div>
                            </div>
                            
                         
                            
                            
                            <div class="bd-course-curriculum mb-30">
                                <h3 class="bd-course-details-content-title">Curriculum</h3>
                                <div class="accordion-common-style accordion-transparent">
                                    <div class="accordion" id="accordionExample">
                                        
                                        
                                        
                                        
                                        
                                        
                                        <div class="accordion custom-accordion" id="accordionContent">
                    
      <?php 
      $sections = $this->db->get_where('section',array('course_id' => $course_details['id']))->result_array();
      $is_course_instructor = 0;
      foreach($sections as $key => $section): 
      $lesson_details = $this->db->get_where('lesson',array('section_id' => $section['id']))->row_array();
      
      ?>
        

        <!-- Study plan START-->
        <?php
          if($section['restricted_by'] == 'date_range' && time() >= $section['start_date'] && time() <= $section['end_date']){
            $is_restricted = 0;
          }

          if($section['restricted_by'] == 'start_date' && time() >= $section['start_date']){
            $is_restricted = 0;
          }

          if($section['restricted_by'] == ''){
            $is_restricted = 0;
          }

          if($is_course_instructor || $this->session->userdata('admin_login')){
            $is_restricted = 0;
          }

          if($is_restricted){
            $restricted_section_ids[] = $section['id'];
          }
        ?>
        <!-- Study plan END-->

        <div class="accordion-item">
          <h2 class="accordion-header" id="section<?php echo $section['id']; ?>">
            <button class="accordion-button <?php if($lesson_details['section_id'] != $section['id']) echo 'collapsed'; ?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne<?php echo $section['id'] ?>" aria-expanded="true" aria-controls="collapseOne<?php echo $section['id'] ?>">
              <div class="d-flex flex-column" style="line-height:28px">
                <span><?php echo $section['title']; ?></span>

                <!-- Study plan start-->
                <?php if(date('d-M-Y-H-i-s', $section['start_date']) != date('d-M-Y-H-i-s', $section['end_date'])): ?>
                    <small class="text-12px text-muted" data-bs-toggle="tooltip" title="<?php echo get_phrase('Study plan') ?>">
                        <i class="far fa-calendar-alt"></i>
                        <?php if(date('d-M-Y', $section['start_date']) == date('d-M-Y', $section['end_date'])): ?>
                             <?php echo date('d M Y', $section['start_date']); ?>:
                             <?php echo date('h:i A', $section['start_date']).' - '.date('h:i A', $section['end_date']); ?>
                        <?php else: ?>
                            <?php echo date('d M Y h:i A', $section['start_date']).' - '.date('d M Y h:i A', $section['end_date']); ?>
                        <?php endif ?>
                    </small>
                <?php endif; ?>
                <!-- Study plan END-->
              </div>
                
            </button>
          </h2>
          <div id="collapseOne<?php echo $section['id'] ?>" class="accordion-collapse collapse <?php if($lesson_details['section_id'] == $section['id']) echo 'show'; ?>" aria-labelledby="section<?php echo $section['id']; ?>" data-bs-parent="#accordionContent">
            <div class="accordion-body position-relative">
            
            <?php
                $lessons = $this->crud_model->get_lessons('section', $section['id'])->result_array();
                foreach($lessons as $key => $lesson):
                if(isset($bundle_id) && $bundle_id > 0):
                    $lesson_url = site_url('addons/course_bundles/lesson/'.rawurlencode(slugify($course_details['title'])).'/'.$bundle_id.'/'.$course_id.'/'.$lesson['id']);
                  else:
                    $lesson_url = site_url('home/lesson/'.slugify($course_details['title']).'/'.$course_id.'/'.$lesson['id']);
                  endif;
                  //End check is bundle or course
                  ?>     
              <a href="#" class="bd-course-curriculum-content d-flex-between">
                                                        <div class="bd-course-curriculum-info d-flex-items gap-10">
                                                            <div class="icon"><i class="fa-solid fa-video"></i></div>
                                                            <p class="title"><?php echo $lesson['title']; ?></p>
                                                        </div>
                                                        <div class="bd-course-curriculum-meta d-flex-items gap-10">
                                                            <span class="duration"><?php echo $lesson['duration']; ?></span>
                                                            <span class="status"><i class="fa-solid fa-lock"></i></span>
                                                        </div>
                                                    </a>
                                                    <a href="#" class="bd-course-curriculum-content d-flex-between">
                                                 
                      <?php endforeach; ?>
                
              </ul>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
                                        
                                        <!-- Section 1 -->
                                        
                                    </div>
                                </div>
                            </div>
                            <div class="bd-course-instructors mb-30">
                                <h3 class="bd-course-details-content-title">Instructors</h3>
                                <?php // include "course_page_instructor.php"; ?>
                            </div>
                            <div class="bd-student-feedback mb-30">
                                <h3 class="bd-course-details-content-title">Student Feedback</h3>
                                <div class="bd-review-rating-wrapper">
                                    <div class="row gy-30 align-items-center">
                                        <div class="col-xl-3 col-lg-3 col-md-4 col-sm-4">
                                            <div class="bd-rating-box">
                                                <div class="bd-rating-box-number">4.9</div>
                                                <div class="bd-rating-box-icon">
                                                    <a href="#"><i class="fa fa-star"></i></a>
                                                    <a href="#"><i class="fa fa-star"></i></a>
                                                    <a href="#"><i class="fa fa-star"></i></a>
                                                    <a href="#"><i class="fa fa-star"></i></a>
                                                    <a href="#"><i class="fa fa-star"></i></a>
                                                </div>
                                                <span class="bd-rating-box-title">(0 Reviews)</span>
                                            </div>
                                        </div>

                                        <div class="col-xl-9 col-lg-9 col-md-8 col-sm-12">
                                            <div class="bd-review-progress-wrapper">
                                                <!-- Rating for 5 Stars -->
                                                <div class="bd-review-progress-bar progress-style-2">
                                                    <div class="bd-review-text">5</div>
                                                    <div class="single-progress">
                                                        <div class="progress">
                                                            <div class="progress-bar bar-bg-3 wow bdFadeInLeft" data-wow-duration="0.5s" data-wow-delay=".3s" role="progressbar" style="width: 90%" aria-valuenow="90" aria-valuemin="0" aria-valuemax="100"></div>
                                                        </div>
                                                    </div>
                                                    <div class="bd-review-meta">
                                                        <span class="bd-review-percent">82%</span>
                                                        <span class="bd-review-number">212</span>
                                                    </div>
                                                </div>

                                                <!-- Rating for 4 Stars -->
                                                <div class="bd-review-progress-bar progress-style-2">
                                                    <div class="bd-review-text">4</div>
                                                    <div class="single-progress">
                                                        <div class="progress">
                                                            <div class="progress-bar bar-bg-2 wow bdFadeInLeft" data-wow-duration="0.5s" data-wow-delay=".3s" role="progressbar" style="width: 75%" aria-valuenow="75" aria-valuemin="0" aria-valuemax="100"></div>
                                                        </div>
                                                    </div>
                                                    <div class="bd-review-meta">
                                                        <span class="bd-review-percent">12%</span>
                                                        <span class="bd-review-number">28</span>
                                                    </div>
                                                </div>

                                                <!-- Rating for 3 Stars -->
                                                <div class="bd-review-progress-bar progress-style-2">
                                                    <div class="bd-review-text">3</div>
                                                    <div class="single-progress">
                                                        <div class="progress">
                                                            <div class="progress-bar bar-bg-4 wow bdFadeInLeft" data-wow-duration="0.5s" data-wow-delay=".3s" role="progressbar" style="width: 50%" aria-valuenow="50" aria-valuemin="0" aria-valuemax="100"></div>
                                                        </div>
                                                    </div>
                                                    <div class="bd-review-meta">
                                                        <span class="bd-review-percent">4%</span>
                                                        <span class="bd-review-number">9</span>
                                                    </div>
                                                </div>

                                                <!-- Rating for 2 Stars -->
                                                <div class="bd-review-progress-bar progress-style-2">
                                                    <div class="bd-review-text">2</div>
                                                    <div class="single-progress">
                                                        <div class="progress">
                                                            <div class="progress-bar bar-bg-5 wow bdFadeInLeft" data-wow-duration="0.5s" data-wow-delay=".3s" role="progressbar" style="width: 30%" aria-valuenow="30" aria-valuemin="0" aria-valuemax="100"></div>
                                                        </div>
                                                    </div>
                                                    <div class="bd-review-meta">
                                                        <span class="bd-review-percent">1%</span>
                                                        <span class="bd-review-number">5</span>
                                                    </div>
                                                </div>

                                                <!-- Rating for 1 Star -->
                                                <div class="bd-review-progress-bar progress-style-2">
                                                    <div class="bd-review-text">1</div>
                                                    <div class="single-progress">
                                                        <div class="progress">
                                                            <div class="progress-bar bar-bg-6 wow bdFadeInLeft" data-wow-duration="0.5s" data-wow-delay=".3s" role="progressbar" style="width: 10%" aria-valuenow="10" aria-valuemin="0" aria-valuemax="100"></div>
                                                        </div>
                                                    </div>
                                                    <div class="bd-review-meta">
                                                        <span class="bd-review-percent">1%</span>
                                                        <span class="bd-review-number">1</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            
                        </div>
                    </div>
                    <div class="col-xxl-4 col-xl-4 col-lg-4">
                        <div class="bd-course-sidebar-widget sidebar-right sidebar-sticky">
                            <div class="bd-course-sidebar-widget-thumb mb-20 p-relative">
                                

                                <img loading="lazy" class="w-100" src="<?php echo $this->crud_model->get_course_thumbnail_url($course_details['id']); ?>">
                               <div class="thumb-btn">
                                    <a class="bd-video-btn popup-video has-bg" href="<?php echo site_url('home/course_preview/' . $course_details['id']); ?>">
                                        <span class="icon"><i class="fa-solid fa-play"></i></span>
                                    </a>
                                </div>
                            </div>
                            <div class="bd-course-sidebar-widget-price mb-20">
                                <div class="bd-course-price">
                                    <?php if ($course_details['is_free_course']) : ?>
                                <span class="current-price"><?php echo get_phrase('Free'); ?></span>
                            <?php elseif ($course_details['discount_flag']) : ?>
                                 <span class="current-price"><?php echo currency($course_details['discounted_price']); ?></span>
                                 <span class="old-price"><?php echo currency($course_details['price']); ?><span>
                            <?php else : ?>
                               <span class="current-price"><?php echo currency($course_details['price']); ?></span>
                            <?php endif; ?>

                                
                                </div>
                            </div>
                            <div class="bd-course-sidebar-widget-list mb-20">
                                <ul>
                                    <li>
                                        <div class="icon">
                                            <i class="fas fa-filter"></i>
                                            <span>Level</span>
                                        </div>
                                        <div class="video-corse-info">
                                            <span><?php echo get_phrase($course_details['level']); ?></span>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="icon">
                                            <i class="fas fa-desktop"></i>
                                            <span>Lectures</span>
                                        </div>
                                        <div class="video-corse-info">
                                            <span><?php echo get_phrase('Lectures') ?> Lectures</span>
                                        </div>
                                    </li>
                                     <?php $number_of_quiz = $this->db->get_where('lesson', ['course_id' => $course_details['id'], 'lesson_type' => 'quiz'])->num_rows(); ?>
                        <?php if ($number_of_quiz > 0) : ?>
                             <li>
                                        <div class="icon">
                                            <i class="far fa-clock"></i>
                                            <span>Quiz</span>
                                        </div>
                                        <div class="video-corse-info">
                                            <span><?php echo $number_of_quiz; ?></span>
                                        </div>
                                    </li>
                            
                        <?php endif; ?>

                                   
                                    <li>
                                        <div class="icon">
                                            <i class="fas fa-th-list"></i>
                                            <span>Category</span>
                                        </div>
                                        <div class="video-corse-info">
                                            <span>Data Science</span>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="icon">
                                            <i class="fas fa-globe"></i>
                                            <span>Language</span>
                                        </div>
                                        <div class="video-corse-info">
                                            <span>English</span>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="icon">
                                            <i class="fas fa-bookmark"></i>
                                            <span><?php echo get_phrase('Expiry period') ?></span>
                                        </div>
                                        <div class="video-corse-info">
                                             <?php if ($course_details['expiry_period'] <= 0) : ?>
                                            <span><?php echo get_phrase('Lifetime') ?></span>
                                <?php else : ?>
                                   <span> <?php echo $course_details['expiry_period'] . ' ' . get_phrase('Months'); ?>
                              </span>
                                <?php endif; ?>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="icon">
                                            <i class="fas fa-award"></i>
                                            <span>Certificate</span>
                                        </div>
                                        <div class="video-corse-info">
                                            <span><?php echo get_phrase('Yes') ?></span>
                                        </div>
                                    </li>
                                    
                                </ul>
                            </div>
                            <div class="bd-course-sidebar-widget-btn d-flex-between flex-wrap gap-15">
                                
                                <?php $cart_items = $this->session->userdata('cart_items'); ?>
                            <?php if (is_purchased($course_details['id'])) : ?>
                                <a href="<?php echo site_url('home/lesson/' . slugify($course_details['title']) . '/' . $course_details['id']) ?>" class="bd-btn btn-primary w-100"><i class="far fa-play-circle"></i> <?php echo get_phrase('Start Now'); ?></a>
                                <?php if ($course_details['is_free_course'] != 1) : ?>
                                    <a href="#" onclick="actionTo('<?php echo site_url('home/handle_buy_now/' . $course_details['id'] . '?gift=1'); ?>')" class="bd-btn btn-primary w-100"><i class="fas fa-gift"></i> <?php echo get_phrase('Gift someone else'); ?></a>
                                <?php endif; ?>
                            <?php else : ?>
                                <?php if ($course_details['is_free_course'] == 1) : ?>
                                    <a href="<?php echo site_url('home/get_enrolled_to_free_course/' . $course_details['id']); ?>" class="bd-btn btn-outline-primary w-100"><?php echo get_phrase('Enroll Now'); ?></a>
                                <?php else : ?>

                                    <!-- Cart button -->
                                    <a id="added_to_cart_btn_<?php echo $course_details['id']; ?>" class="<?php if (!in_array($course_details['id'], $cart_items)) echo 'd-hidden'; ?> active bd-btn btn-primary w-100" href="#" onclick="actionTo('<?php echo site_url('home/handle_cart_items/' . $course_details['id']); ?>');"><i class="fas fa-minus"></i> <?php echo get_phrase('Remove from cart'); ?></a>
                                    <a id="add_to_cart_btn_<?php echo $course_details['id']; ?>" class="<?php if (in_array($course_details['id'], $cart_items)) echo 'd-hidden'; ?> bd-btn btn-primary w-100" href="#" onclick="actionTo('<?php echo site_url('home/handle_cart_items/' . $course_details['id']); ?>'); " ><i class="fas fa-plus"></i> <?php echo get_phrase('Add to cart'); ?></a>
                                    <!-- Cart button ended-->

                                    <a href="#" onclick="actionTo('<?php echo site_url('home/handle_buy_now/' . $course_details['id']); ?>')" class="bd-btn btn-primary w-100"><i class="fas fa-credit-card"></i> <?php echo get_phrase('Buy Now'); ?></a>
                                <?php endif; ?>
                            <?php endif; ?>
                                     <?php
                        if (isset($user_data['unique_identifier'])) :
                            $ref = $user_data['unique_identifier'];
                        else :
                            $ref = '';
                        endif;
                        ?>
                        
                        
                            <?php if (addon_status('affiliate_course')) : // course_addon start  adding
                                $CI    = &get_instance();
                                $CI->load->model('addons/affiliate_course_model');
                                $is_affiliattor = $CI->affiliate_course_model->is_affilator($this->session->userdata('user_id'));
                                if ($is_affiliattor == 1) :
                                    $user_data = $CI->affiliate_course_model->get__affiliator_status_table_info_by_user_id($this->session->userdata('user_id'));
                            ?>

                                    <a class="btn-custom_coursepage text-decoration-none fw-600 hover-shadow-1 d-inline-block" href="#myModel" data-bs-toggle="modal" data-bs-target="#myModel" id="shareBtn" data-bs-placement="top"><i class="fas fa-user-plus"></i> <?php echo site_phrase('Share and Earn'); ?></a>
        
                                <?php endif; ?>
                            <?php endif; ?>
                                <div class="eSocialShare d-flex align-items-center w-100">
                            <?php $share_url = site_url('home/course/' . slugify($course_details['title']) . '/' . $course_details['id']); ?>
                            <p><?php echo  site_phrase('Share this course');?></p>
                            <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo $share_url; ?>&ref=<?php echo $ref; ?>" target="_blank" class="p-2" style="color: #316FF6;" data-bs-toggle="tooltip" title="<?php echo get_phrase('Share on Facebook'); ?>" data-bs-placement="top">
                                <svg width="19" height="19" viewBox="0 0 19 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <g clip-path="url(#clip0_30_3727)">
                                    <path d="M18.902 8.99994C18.902 4.02941 14.6706 0 9.45099 0C4.23135 0 0 4.02941 0 8.99994C0 13.492 3.45607 17.2154 7.97427 17.8905V11.6015H5.57461V8.99994H7.97427V7.01714C7.97427 4.76153 9.38528 3.5156 11.5441 3.5156C12.5778 3.5156 13.6596 3.69138 13.6596 3.69138V5.90621H12.4679C11.2939 5.90621 10.9277 6.60001 10.9277 7.31245V8.99994H13.5489L13.1299 11.6015H10.9277V17.8905C15.4459 17.2154 18.902 13.492 18.902 8.99994Z" fill="#000"/>
                                    </g>
                                    <defs>
                                    <clipPath id="clip0_30_3727">
                                    <rect width="18.902" height="17.9999" fill="white"/>
                                    </clipPath>
                                    </defs>
                             </svg>
                            </a>
                            <a href="https://twitter.com/intent/tweet?url=<?php echo $share_url; ?>&text=<?php echo $course_details['title']; ?>&ref=<?php echo $ref; ?>" target="_blank" class="p-2" style="color: #1DA1F2;" data-bs-toggle="tooltip" title="<?php echo get_phrase('Share on Twitter'); ?>" data-bs-placement="top">
                            <svg width="19" height="19" viewBox="0 0 20 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0_30_3730)">
                                <path d="M11.2841 7.5801L18.2156 0H16.5731L10.5545 6.5817L5.74746 0H0.203125L7.47229 9.95269L0.203125 17.9016H1.84575L8.20153 10.9511L13.2781 17.9016H18.8224L11.2837 7.5801H11.2841ZM9.03434 10.0404L8.29782 9.04931L2.43761 1.16331H4.96059L9.68985 7.52757L10.4264 8.51863L16.5738 16.7912H14.0509L9.03434 10.0408V10.0404Z" fill="#0D0C23"/>
                                </g>
                                <defs>
                                <clipPath id="clip0_30_3730">
                                <rect width="19.0285" height="17.9016" fill="white"/>
                                </clipPath>
                                </defs>
                                </svg>

                            </a>
                            <a href="https://api.whatsapp.com/send?text=<?php echo $share_url; ?>&ref=<?php echo $ref; ?>" target="_blank" class="p-2" style="color: #128c7e;" data-bs-toggle="tooltip" title="<?php echo get_phrase('Share on Whatsapp'); ?>" data-bs-placement="top">
                                <i class="fab fa-whatsapp text-20px dark"></i>
                            </a>
                            <a href="https://www.linkedin.com/shareArticle?url=<?php echo $share_url; ?>&title=<?php echo $course_details['title']; ?>&summary=<?php echo $course_details['short_description']; ?>&ref=<?php echo $ref; ?>" target="_blank" class="p-2" style="color: #0077b5;" data-bs-toggle="tooltip" title="<?php echo get_phrase('Share on Linkedin'); ?>" data-bs-placement="top">
                            <svg width="19" height="19" viewBox="0 0 19 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0_30_3738)">
                                <path d="M17.5028 0H1.3955C0.623913 0 0 0.580074 0 1.29726V16.6991C0 17.4163 0.623913 17.9999 1.3955 17.9999H17.5028C18.2744 17.9999 18.902 17.4163 18.902 16.7026V1.29726C18.902 0.580074 18.2744 0 17.5028 0ZM5.60783 15.3386H2.80207V6.74644H5.60783V15.3386ZM4.20495 5.57574C3.30416 5.57574 2.57687 4.88317 2.57687 4.02888C2.57687 3.17459 3.30416 2.48201 4.20495 2.48201C5.10206 2.48201 5.82934 3.17459 5.82934 4.02888C5.82934 4.87965 5.10206 5.57574 4.20495 5.57574ZM16.1073 15.3386H13.3052V11.162C13.3052 10.1671 13.2868 8.88392 11.847 8.88392C10.3887 8.88392 10.1672 9.97025 10.1672 11.0917V15.3386H7.36882V6.74644H10.0564V7.92065H10.0934C10.4662 7.24565 11.3818 6.53199 12.7441 6.53199C15.5831 6.53199 16.1073 8.31088 16.1073 10.6241V15.3386Z" fill="#000"/>
                                </g>
                                <defs>
                                <clipPath id="clip0_30_3738">
                                <rect width="18.902" height="17.9999" rx="2" fill="white"/>
                                </clipPath>
                                </defs>
                                </svg>

                            </a>
                           
                        </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        
        

<!-------- Related course section start ----->
<section class="courses grid-view-body course-details-card mt-5">
    <div class="container">
        <h1><?php echo get_phrase('Related Courses'); ?></h1>
        <div class="courses-card mt-5">
            <div class="row">
                <?php $related_courses = $this->crud_model->get_related_courses($course_details['category_id'], $course_details['sub_category_id'], $course_details['id'], 12)->result_array(); ?>
                <?php foreach ($related_courses as $key => $course) :

                    $lessons = $this->crud_model->get_lessons('course', $course['id']);
                    $instructor_details = $this->user_model->get_all_user($course['user_id'])->row_array();
                    $course_duration = $this->crud_model->get_total_duration_of_lesson_by_course_id($course['id']);
                    $total_rating =  $this->crud_model->get_ratings('course', $course['id'], true)->row()->rating;
                    $number_of_ratings = $this->crud_model->get_ratings('course', $course['id'])->num_rows();
                    if ($number_of_ratings > 0) {
                        $average_ceil_rating = ceil($total_rating / $number_of_ratings);
                    } else {
                        $average_ceil_rating = 0;
                    }
                ?>
                    <div class="col-lg-3 col-md-4 col-sm-6 col-12">
                        <a href="<?php echo site_url('home/course/' . rawurlencode(slugify($course['title'])) . '/' . $course['id']); ?>" class="checkPropagation eGridCourse  courses-card-body epopCourse  position-relative">
                            <div class="courses-card-image">
                                <img loading="lazy" src="<?php echo $this->crud_model->get_course_thumbnail_url($course['id']); ?>">
                                <div class="courses-icon <?php if (in_array($course['id'], $my_wishlist_items)) echo 'red-heart'; ?>" id="coursesWishlistIcon<?php echo $course['id']; ?>">
                                    <i class="fa-solid fa-heart checkPropagation" onclick="actionTo('<?php echo site_url('home/toggleWishlistItems/' . $course['id']); ?>')"></i>
                                </div>
                                <div class="courses-card-image-text">
                                    <h3><?php echo get_phrase($course['level']); ?></h3>
                                </div>
                            </div>
                            <div class="courses-text">
                                <h5 class="mb-2"><?php echo $course['title']; ?></h5>
                                <div class="review-icon">
                                        <div class="review-icon-star align-item-center">
                                        <p><i class="fa-solid fa-star <?php if ($number_of_ratings > 0) echo 'filled'; ?>"></i></p>
                                            <p class="mr-5px"><?php echo $average_ceil_rating; ?></p>
                                            <p>(<?php echo $number_of_ratings; ?> <?php echo get_phrase('Reviews') ?>)</p>
                                        </div>
                                    <div class="review-btn">
                                        <span data-bs-toggle="tooltip" data-bs-title="<?php echo site_phrase('Compare')?>" class="compare-img echecks  checkPropagation" onclick="redirectTo('<?php echo base_url('home/compare?course-1=' . slugify($course['title']) . '&course-id-1=' . $course['id']); ?>');">
                                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M13.6134 8.14665C13.3401 8.14665 13.1134 7.91998 13.1134 7.64665V5.43335C13.1134 4.60668 12.4401 3.93335 11.6134 3.93335H2.38672C2.11339 3.93335 1.88672 3.70668 1.88672 3.43335C1.88672 3.16002 2.11339 2.93335 2.38672 2.93335H11.6134C12.9934 2.93335 14.1134 4.05335 14.1134 5.43335V7.64665C14.1134 7.92665 13.8867 8.14665 13.6134 8.14665Z" fill="#0D0C23"/>
                                            <path d="M4.49339 6.04665C4.36672 6.04665 4.24006 5.99996 4.14006 5.89996L2.03339 3.79332C1.94005 3.69998 1.88672 3.5733 1.88672 3.43996C1.88672 3.30663 1.94005 3.17998 2.03339 3.08665L4.14006 0.979961C4.33339 0.786628 4.65339 0.786628 4.84672 0.979961C5.04005 1.17329 5.04005 1.49333 4.84672 1.68667L3.0934 3.43996L4.84672 5.1933C5.04005 5.38663 5.04005 5.70663 4.84672 5.89996C4.74672 5.9933 4.62005 6.04665 4.49339 6.04665Z" fill="#0D0C23"/>
                                            <path d="M13.6134 13.06H4.38672C3.00672 13.06 1.88672 11.94 1.88672 10.56V8.34668C1.88672 8.07335 2.11339 7.84668 2.38672 7.84668C2.66005 7.84668 2.88672 8.07335 2.88672 8.34668V10.56C2.88672 11.3867 3.56005 12.06 4.38672 12.06H13.6134C13.8867 12.06 14.1134 12.2867 14.1134 12.56C14.1134 12.8334 13.8867 13.06 13.6134 13.06Z" fill="#0D0C23"/>
                                            <path d="M11.5068 15.1666C11.3801 15.1666 11.2535 15.12 11.1535 15.02C10.9601 14.8267 10.9601 14.5066 11.1535 14.3133L12.9068 12.56L11.1535 10.8067C10.9601 10.6133 10.9601 10.2933 11.1535 10.1C11.3468 9.90665 11.6668 9.90665 11.8601 10.1L13.9668 12.2066C14.0601 12.3 14.1135 12.4267 14.1135 12.56C14.1135 12.6933 14.0601 12.82 13.9668 12.9133L11.8601 15.02C11.7668 15.12 11.6401 15.1666 11.5068 15.1666Z" fill="#0D0C23"/>
                                        </svg>
                                        </span>
                                    </div>
                                </div>
                                 <!--  -->
                                 <div class="duration-time">
                                    <?php if($course_duration): ?>
                                    <p class="m-0"> 
                                        <i class="fa-regular fa-clock p-0 text-15px"></i> <?php echo $course_duration; ?></p>
                                    <?php endif; ?>
                                </div>
                                <!--  -->
                                <!-- <p class="ellipsis-line-2 mx-0"><?php echo $course['short_description']; ?></p> -->
                                <div class="courses-price-border">
                                    <div class="courses-price">
                                        <div class="courses-price-left">
                                            <?php if ($course['is_free_course']) : ?>
                                                <h5><?php echo get_phrase('Free'); ?></h5>
                                            <?php elseif ($course['discount_flag']) : ?>
                                                <h5><?php echo currency($course['discounted_price']); ?></h5>
                                                <p class="mt-1"><del><?php echo currency($course['price']); ?></del></p>
                                            <?php else : ?>
                                                <h5><?php echo currency($course['price']); ?></h5>
                                            <?php endif; ?>
                                        </div>
                                        <div class="courses-price-right ">
                                          <?php if(is_purchased($course['id'])): ?>
                                                <span class="enrollBtn"><i class="far fa-play-circle text-white"></i> <?php echo get_phrase('Start Now'); ?></span>
                                              <?php else: ?>
                                           <span class="enrollBtn"><?php echo site_phrase('Enroll Now')?></span>
                                           <?php endif; ?>
                                         </div>
                                    </div>
                                </div>
                            </div>
                        </a>
                    </div>
                <?php endforeach ?>
            </div>
        </div>
    </div>
</section>
<!-------- Related course section end ----->


<?php if (addon_status('affiliate_course') && $is_affiliattor == 1) : ?>
    <?php include 'affiliate_course_modal.php';  // course_addon  single line /adding 
    ?>
<?php endif; ?>

<?php if (addon_status('team_training')) : ?>
    <?php include 'course_related_packages.php'; ?>
<?php endif; ?>