<div class="grid-view-body courses">
    <?php // include 'courses_page_sorting_section.php'; ?>

    <div class="courses-card ">
        <div class="row">
            <?php foreach ($courses as $course) : ?>
                <?php
                $lessons = $this->crud_model->get_lessons('course', $course['id']);
                $instructor_details = $this->user_model->get_all_user($course['user_id'])->row_array();
                $course_duration = $this->crud_model->get_total_duration_of_lesson_by_course_id($course['id']);
                $total_rating =  $this->crud_model->get_ratings('course', $course['id'], true)->row()->rating;
                $number_of_ratings = $this->crud_model->get_ratings('course', $course['id'])->num_rows();
                if ($number_of_ratings > 0) {
                    $average_ceil_rating = ceil($total_rating / $number_of_ratings);
                } else {
                    $average_ceil_rating = 0;
                }
                ?>
                
                 <div class="col-lg-4 col-md-4 col-sm-4 col-12">
                        <div class="bd-course-wrapper style-ten">
                            <div class="bd-course-thumb-wrapper bd-course-thumb-style p-relative">
                                
                                <div class="bd-course-thumb-bg bg-1"><img src="<?php echo $this->crud_model->get_course_thumbnail_url($course['id']); ?>" alt="images"></div>
                                
                            </div>
                            <div class="bd-course-content primary-bg">
                                <a class="bd-badge badge-danger mb-10" href="<?php echo site_url('home/course/' . rawurlencode(slugify($course['title'])) . '/' . $course['id']); ?>"><?php echo currency($course['price']); ?></a>
                                <h5 class="bd-course-title underline mb-10"><a href="<?php echo site_url('home/course/' . rawurlencode(slugify($course['title'])) . '/' . $course['id']); ?>"><?php echo $course['title']; ?></a></h5>
                               
                                <div class="bd-course-content-bottom d-flex align-items-center">
                                    <?php if(is_purchased($course['id'])): ?>
                                            <span class="bd-btn btn-primary w-100 checkPropagation" onclick="redirectTo('<?php echo site_url('home/lesson/'.slugify($course['title']).'/'.$course['id']) ?>');"><i class="far fa-play-circle text-white"></i> <?php echo get_phrase('Start Now'); ?></span>
                                        <?php else: ?>
                                            <span class="bd-btn btn-primary w-100" onclick="redirectTo('<?php echo site_url('home/lesson/'.slugify($course['title']).'/'.$course['id']) ?>');"><?php echo site_phrase('Enroll Now')?></span>
                                        <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    
                
            <?php endforeach; ?>
        </div>
        <!------- pagination Start ------>
        <div class="pagenation-items mb-0 mt-3">
            <?php echo $this->pagination->create_links(); ?>
        </div>
        <!------- pagination end ------>
    </div>
</div>