<?php if(get_frontend_settings('recaptcha_status')): ?>
  <script src="https://www.google.com/recaptcha/api.js" async defer></script>
<?php endif; ?>

<!---------- Header Section End  ---------->
<section class="sign-up my-5 pt-25" style="margin-top:20px">
    <div class="container">
        <div class="row">
            <div class="col-lg-7 col-md-6 col-sm-12 col-12 text-center">
                <img loading="lazy" width="65%" src="<?php echo site_url('assets/frontend/default-new/image/login-security.gif') ?>">
            </div>
            <div class="col-lg-5 col-md-6 col-sm-12 col-12 ">
                <div class="sing-up-right">
                    <h3><?php echo get_phrase('Sign Up'); ?><span>!</span></h3>
                   <form action="<?php echo site_url('login/register') ?>" method="post" enctype="multipart/form-data" id="signup-form">
                        <div class="mb-4">
                            <div class="position-relative">
                                <input class="form-control" id="first_name" type="text" name="first_name" placeholder="<?php echo get_phrase('Enter your first name'); ?>" required>
                            </div>
                        </div>
                        <div class="mb-4">
                            <div class="position-relative">
                                 <input class="form-control" id="last_name" type="text" name="last_name" placeholder="<?php echo get_phrase('Enter your last name'); ?>" required>
                            </div>
                        </div>
                        <div class="mb-4">
                             <div class="position-relative">
                                 <input class="form-control" id="email" type="email" name="email" placeholder="<?php echo get_phrase('Enter your email'); ?>" required>
                            </div>
                        </div>
                        <div class="mb-4">
                             <div class="position-relative">
                                <input class="form-control" id="password" type="password" name="password" placeholder="<?php echo get_phrase('Enter your valid password'); ?>" required>
                            </div>
                        </div>

                        <?php if(get_settings('allow_instructor')): ?>
                            <div class="mb-4">
                                <input id="instructor" type="checkbox" onchange="$('#become-instructor-fields').toggle()" name="instructor" value="yes" <?php echo isset($_GET['instructor']) ? 'checked':''; ?>>
                                <label for="instructor"><?php echo get_phrase('Apply to Become an instructor'); ?></label>
                            </div>

                            <div id="become-instructor-fields" class="<?php echo isset($_GET['instructor']) ?  '':'d-hidden'; ?>">
                                <div class="mb-4">
                                    <div class="position-relative">
                                        <input class="form-control" id="phone" type="phone" name="phone" placeholder="<?php echo get_phrase('Enter your phone number'); ?>">
                                    </div>
                                </div>
                                <div class="mb-4">
                                     <div class="position-relative">
                                        <input class="form-control" id="document" type="file" name="document">
                                        <small><?php echo get_phrase('Provide some documents about your qualifications'); ?></small>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <div class="position-relative">
                                        <textarea class="form-control" name="message" rows="4"></textarea>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>

                        <?php if(get_frontend_settings('recaptcha_status')): ?>
                            <div class="g-recaptcha" data-sitekey="<?php echo get_frontend_settings('recaptcha_sitekey'); ?>"></div>
                        <?php endif; ?>

                        <?php if(get_frontend_settings('recaptcha_status_v3')): ?>
                        <div class="log-in">
                            <button class="bd-btn btn-primary w-100 g-recaptcha" data-sitekey="<?php echo get_frontend_settings('recaptcha_sitekey_v3'); ?>" data-callback='onSignupSubmit' data-action='submit'>
                                <?php echo get_phrase('Sign Up'); ?>
                            </button>
                        </div>
                        <?php else: ?>
                        
                        <div class="log-in">
                            <button type="submit" class="bd-btn btn-primary w-100">
                                <?php echo get_phrase('Sign Up') ?>
                            </button>
                        </div>
                        <?php endif; ?>
                    </form>

                    
                </div>
            </div>
        </div>
    </div>
</section>

<script>
    function onSignupSubmit(token) {
        document.getElementById("signup-form").submit();
    }
</script>